/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class MESADRMImage {
    public static final int EGL_DRM_BUFFER_FORMAT_MESA = 12752;
    public static final int EGL_DRM_BUFFER_USE_MESA = 12753;
    public static final int EGL_DRM_BUFFER_FORMAT_ARGB32_MESA = 12754;
    public static final int EGL_DRM_BUFFER_MESA = 12755;
    public static final int EGL_DRM_BUFFER_STRIDE_MESA = 12756;
    public static final int EGL_DRM_BUFFER_USE_SCANOUT_MESA = 1;
    public static final int EGL_DRM_BUFFER_USE_SHARE_MESA = 2;

    protected MESADRMImage() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateDRMImageMESA, caps.eglExportDRMImageMESA);
    }

    public static long neglCreateDRMImageMESA(long dpy, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, attrib_list);
    }

    public static long eglCreateDRMImageMESA(long dpy, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return MESADRMImage.neglCreateDRMImageMESA(dpy, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int neglExportDRMImageMESA(long dpy, long image, long name, long handle, long stride) {
        long __functionAddress = EGL.getCapabilities().eglExportDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, name, handle, stride);
    }

    public static boolean eglExportDRMImageMESA(long dpy, long image, IntBuffer name, IntBuffer handle, IntBuffer stride) {
        if (Checks.CHECKS) {
            if (name != null) {
                Checks.checkBuffer((Buffer)name, 1);
            }
            if (handle != null) {
                Checks.checkBuffer((Buffer)handle, 1);
            }
            if (stride != null) {
                Checks.checkBuffer((Buffer)stride, 1);
            }
        }
        return MESADRMImage.neglExportDRMImageMESA(dpy, image, MemoryUtil.memAddressSafe(name), MemoryUtil.memAddressSafe(handle), MemoryUtil.memAddressSafe(stride)) != 0;
    }

    public static long eglCreateDRMImageMESA(long dpy, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPP(__functionAddress, dpy, attrib_list);
    }

    public static boolean eglExportDRMImageMESA(long dpy, long image, int[] name, int[] handle, int[] stride) {
        long __functionAddress = EGL.getCapabilities().eglExportDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
            if (name != null) {
                Checks.checkBuffer(name, 1);
            }
            if (handle != null) {
                Checks.checkBuffer(handle, 1);
            }
            if (stride != null) {
                Checks.checkBuffer(stride, 1);
            }
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, name, handle, stride) != 0;
    }
}

