/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public abstract class GLFWDropCallback
extends Callback
implements GLFWDropCallbackI {
    public static GLFWDropCallback create(long functionPointer) {
        if (functionPointer == 0L) {
            return null;
        }
        GLFWDropCallbackI instance = (GLFWDropCallbackI)Callback.get(functionPointer);
        return instance instanceof GLFWDropCallback ? (GLFWDropCallback)instance : new Container(functionPointer, instance);
    }

    public static GLFWDropCallback create(GLFWDropCallbackI instance) {
        return instance instanceof GLFWDropCallback ? (GLFWDropCallback)instance : new Container(instance.address(), instance);
    }

    protected GLFWDropCallback() {
        super(0L);
        this.address = GLFWDropCallbackI.super.address();
    }

    private GLFWDropCallback(long functionPointer) {
        super(functionPointer);
    }

    public static String getName(long names, int index) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(names + (long)(Pointer.POINTER_SIZE * index)));
    }

    public GLFWDropCallback set(long window) {
        GLFW.glfwSetDropCallback(window, this);
        return this;
    }

    private static final class Container
    extends GLFWDropCallback {
        private final GLFWDropCallbackI delegate;

        Container(long functionPointer, GLFWDropCallbackI delegate) {
            super(functionPointer);
            this.delegate = delegate;
        }

        @Override
        public void invoke(long window, int count, long names) {
            this.delegate.invoke(window, count, names);
        }
    }
}

