/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NVGTextRow
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int START;
    public static final int END;
    public static final int NEXT;
    public static final int WIDTH;
    public static final int MINX;
    public static final int MAXX;

    NVGTextRow(long address, ByteBuffer container) {
        super(address, container);
    }

    public NVGTextRow(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NVGTextRow.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long start() {
        return NVGTextRow.nstart(this.address());
    }

    public long end() {
        return NVGTextRow.nend(this.address());
    }

    public long next() {
        return NVGTextRow.nnext(this.address());
    }

    public float width() {
        return NVGTextRow.nwidth(this.address());
    }

    public float minx() {
        return NVGTextRow.nminx(this.address());
    }

    public float maxx() {
        return NVGTextRow.nmaxx(this.address());
    }

    public NVGTextRow start(long value) {
        NVGTextRow.nstart(this.address(), value);
        return this;
    }

    public NVGTextRow end(long value) {
        NVGTextRow.nend(this.address(), value);
        return this;
    }

    public NVGTextRow next(long value) {
        NVGTextRow.nnext(this.address(), value);
        return this;
    }

    public NVGTextRow width(float value) {
        NVGTextRow.nwidth(this.address(), value);
        return this;
    }

    public NVGTextRow minx(float value) {
        NVGTextRow.nminx(this.address(), value);
        return this;
    }

    public NVGTextRow maxx(float value) {
        NVGTextRow.nmaxx(this.address(), value);
        return this;
    }

    public NVGTextRow set(long start, long end, long next, float width, float minx, float maxx) {
        this.start(start);
        this.end(end);
        this.next(next);
        this.width(width);
        this.minx(minx);
        this.maxx(maxx);
        return this;
    }

    public NVGTextRow nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public NVGTextRow set(NVGTextRow src) {
        return this.nset(src.address());
    }

    public static NVGTextRow malloc() {
        return NVGTextRow.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NVGTextRow calloc() {
        return NVGTextRow.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NVGTextRow create() {
        return new NVGTextRow(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NVGTextRow create(long address) {
        return address == 0L ? null : new NVGTextRow(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NVGTextRow.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NVGTextRow.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NVGTextRow mallocStack() {
        return NVGTextRow.mallocStack(MemoryStack.stackGet());
    }

    public static NVGTextRow callocStack() {
        return NVGTextRow.callocStack(MemoryStack.stackGet());
    }

    public static NVGTextRow mallocStack(MemoryStack stack) {
        return NVGTextRow.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGTextRow callocStack(MemoryStack stack) {
        return NVGTextRow.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGTextRow.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGTextRow.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NVGTextRow.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NVGTextRow.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nstart(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)START);
    }

    public static long nend(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)END);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)WIDTH);
    }

    public static float nminx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINX);
    }

    public static float nmaxx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXX);
    }

    public static void nstart(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)START, Checks.checkPointer(value));
    }

    public static void nend(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)END, Checks.checkPointer(value));
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, Checks.checkPointer(value));
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)WIDTH, value);
    }

    public static void nminx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINX, value);
    }

    public static void nmaxx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXX, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)START));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)END));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            NVGTextRow.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = NVGTextRow.__struct(NVGTextRow.__member(POINTER_SIZE), NVGTextRow.__member(POINTER_SIZE), NVGTextRow.__member(POINTER_SIZE), NVGTextRow.__member(4), NVGTextRow.__member(4), NVGTextRow.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        START = layout.offsetof(0);
        END = layout.offsetof(1);
        NEXT = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        MINX = layout.offsetof(4);
        MAXX = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<NVGTextRow, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NVGTextRow newInstance(long address) {
            return new NVGTextRow(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long start() {
            return NVGTextRow.nstart(this.address());
        }

        public long end() {
            return NVGTextRow.nend(this.address());
        }

        public long next() {
            return NVGTextRow.nnext(this.address());
        }

        public float width() {
            return NVGTextRow.nwidth(this.address());
        }

        public float minx() {
            return NVGTextRow.nminx(this.address());
        }

        public float maxx() {
            return NVGTextRow.nmaxx(this.address());
        }

        public Buffer start(long value) {
            NVGTextRow.nstart(this.address(), value);
            return this;
        }

        public Buffer end(long value) {
            NVGTextRow.nend(this.address(), value);
            return this;
        }

        public Buffer next(long value) {
            NVGTextRow.nnext(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            NVGTextRow.nwidth(this.address(), value);
            return this;
        }

        public Buffer minx(float value) {
            NVGTextRow.nminx(this.address(), value);
            return this;
        }

        public Buffer maxx(float value) {
            NVGTextRow.nmaxx(this.address(), value);
            return this;
        }
    }
}

