/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTStaticBuffer {
    protected EXTStaticBuffer() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCapabilities caps) {
        return Checks.checkFunctions(caps.alBufferDataStatic);
    }

    public static void nalBufferDataStatic(int buffer, int format, long data, int len, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, buffer, format, data, len, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, ByteBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress(data), data.remaining(), freq);
    }

    public static void alBufferDataStatic(int buffer, int format, ShortBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress(data), data.remaining() << 1, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, IntBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress(data), data.remaining() << 2, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, FloatBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress(data), data.remaining() << 2, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, short[] data, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, buffer, format, data, data.length << 1, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, int[] data, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, buffer, format, data, data.length << 2, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, float[] data, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.invokePV(__functionAddress, buffer, format, data, data.length << 2, freq);
    }
}

