/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class INTELAccelerator {
    public static final int CL_ACCELERATOR_DESCRIPTOR_INTEL = 16528;
    public static final int CL_ACCELERATOR_REFERENCE_COUNT_INTEL = 16529;
    public static final int CL_ACCELERATOR_CONTEXT_INTEL = 16530;
    public static final int CL_ACCELERATOR_TYPE_INTEL = 16531;
    public static final int CL_INVALID_ACCELERATOR_INTEL = -1094;
    public static final int CL_INVALID_ACCELERATOR_TYPE_INTEL = -1095;
    public static final int CL_INVALID_ACCELERATOR_DESCRIPTOR_INTEL = -1096;
    public static final int CL_ACCELERATOR_TYPE_NOT_SUPPORTED_INTEL = -1097;

    protected INTELAccelerator() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clCreateAcceleratorINTEL, caps.clRetainAcceleratorINTEL, caps.clReleaseAcceleratorINTEL, caps.clGetAcceleratorInfoINTEL);
    }

    public static long nclCreateAcceleratorINTEL(long context, int accelerator_type, long descriptor_size, long descriptor, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return JNI.callPPPPP(__functionAddress, context, accelerator_type, descriptor_size, descriptor, errcode_ret);
    }

    public static long clCreateAcceleratorINTEL(long context, int accelerator_type, ByteBuffer descriptor, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return INTELAccelerator.nclCreateAcceleratorINTEL(context, accelerator_type, descriptor.remaining(), MemoryUtil.memAddress(descriptor), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int clRetainAcceleratorINTEL(long accelerator) {
        long __functionAddress = CL.getICD().clRetainAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
        }
        return JNI.callPI(__functionAddress, accelerator);
    }

    public static int clReleaseAcceleratorINTEL(long accelerator) {
        long __functionAddress = CL.getICD().clReleaseAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
        }
        return JNI.callPI(__functionAddress, accelerator);
    }

    public static int nclGetAcceleratorInfoINTEL(long accelerator, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetAcceleratorInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
        }
        return JNI.callPPPPI(__functionAddress, accelerator, param_name, param_value_size, param_value, param_value_size_ret);
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, param_value == null ? 0 : param_value.remaining(), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, param_value == null ? 0 : param_value.remaining() << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, param_value == null ? 0 : param_value.remaining() << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long clCreateAcceleratorINTEL(long context, int accelerator_type, ByteBuffer descriptor, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPPPPP(__functionAddress, context, accelerator_type, (long)descriptor.remaining(), MemoryUtil.memAddress(descriptor), errcode_ret);
    }

    public static int clGetAcceleratorInfoINTEL(long accelerator, int param_name, int[] param_value, PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetAcceleratorInfoINTEL;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(accelerator);
            if (param_value_size_ret != null) {
                Checks.checkBuffer(param_value_size_ret, 1);
            }
        }
        return JNI.callPPPPI(__functionAddress, accelerator, param_name, (long)(param_value == null ? 0 : param_value.length << 2), param_value, MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

