/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHREGLEvent {
    public static final int CL_INVALID_EGL_OBJECT_KHR = -1093;
    public static final int CL_COMMAND_EGL_FENCE_SYNC_OBJECT_KHR = 8239;

    protected KHREGLEvent() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions(caps.clCreateEventFromEGLSyncKHR);
    }

    public static long nclCreateEventFromEGLSyncKHR(long context, long sync, long display, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateEventFromEGLSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            Checks.checkPointer(sync);
            Checks.checkPointer(display);
        }
        return JNI.callPPPPP(__functionAddress, context, sync, display, errcode_ret);
    }

    public static long clCreateEventFromEGLSyncKHR(long context, long sync, long display, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return KHREGLEvent.nclCreateEventFromEGLSyncKHR(context, sync, display, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateEventFromEGLSyncKHR(long context, long sync, long display, int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateEventFromEGLSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            Checks.checkPointer(sync);
            Checks.checkPointer(display);
            if (errcode_ret != null) {
                Checks.checkBuffer(errcode_ret, 1);
            }
        }
        return JNI.callPPPPP(__functionAddress, context, sync, display, errcode_ret);
    }
}

