/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBMultiBind {
    protected ARBMultiBind() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glBindBuffersBase, caps.glBindBuffersRange, caps.glBindTextures, caps.glBindSamplers, caps.glBindImageTextures, caps.glBindVertexBuffers);
    }

    public static void nglBindBuffersBase(int target, int first, int count, long buffers) {
        long __functionAddress = GL.getCapabilities().glBindBuffersBase;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, first, count, buffers);
    }

    public static void glBindBuffersBase(int target, int first, IntBuffer buffers) {
        ARBMultiBind.nglBindBuffersBase(target, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers));
    }

    public static void nglBindBuffersRange(int target, int first, int count, long buffers, long offsets, long sizes) {
        long __functionAddress = GL.getCapabilities().glBindBuffersRange;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, target, first, count, buffers, offsets, sizes);
    }

    public static void glBindBuffersRange(int target, int first, IntBuffer buffers, PointerBuffer offsets, PointerBuffer sizes) {
        if (Checks.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (sizes != null) {
                Checks.checkBuffer(sizes, buffers.remaining());
            }
        }
        ARBMultiBind.nglBindBuffersRange(target, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void nglBindTextures(int first, int count, long textures) {
        long __functionAddress = GL.getCapabilities().glBindTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, textures);
    }

    public static void glBindTextures(int first, IntBuffer textures) {
        ARBMultiBind.nglBindTextures(first, textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindSamplers(int first, int count, long samplers) {
        long __functionAddress = GL.getCapabilities().glBindSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, samplers);
    }

    public static void glBindSamplers(int first, IntBuffer samplers) {
        ARBMultiBind.nglBindSamplers(first, samplers == null ? 0 : samplers.remaining(), MemoryUtil.memAddressSafe(samplers));
    }

    public static void nglBindImageTextures(int first, int count, long textures) {
        long __functionAddress = GL.getCapabilities().glBindImageTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, count, textures);
    }

    public static void glBindImageTextures(int first, IntBuffer textures) {
        ARBMultiBind.nglBindImageTextures(first, textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindVertexBuffers(int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = GL.getCapabilities().glBindVertexBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, first, count, buffers, offsets, strides);
    }

    public static void glBindVertexBuffers(int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (Checks.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, buffers.remaining());
            }
        }
        ARBMultiBind.nglBindVertexBuffers(first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glBindBuffersBase(int target, int first, int[] buffers) {
        long __functionAddress = GL.getCapabilities().glBindBuffersBase;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, first, buffers == null ? 0 : buffers.length, buffers);
    }

    public static void glBindBuffersRange(int target, int first, int[] buffers, PointerBuffer offsets, PointerBuffer sizes) {
        long __functionAddress = GL.getCapabilities().glBindBuffersRange;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.length);
            }
            if (sizes != null) {
                Checks.checkBuffer(sizes, buffers.length);
            }
        }
        JNI.callPPPV(__functionAddress, target, first, buffers == null ? 0 : buffers.length, buffers, MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void glBindTextures(int first, int[] textures) {
        long __functionAddress = GL.getCapabilities().glBindTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, textures == null ? 0 : textures.length, textures);
    }

    public static void glBindSamplers(int first, int[] samplers) {
        long __functionAddress = GL.getCapabilities().glBindSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, samplers == null ? 0 : samplers.length, samplers);
    }

    public static void glBindImageTextures(int first, int[] textures) {
        long __functionAddress = GL.getCapabilities().glBindImageTextures;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, first, textures == null ? 0 : textures.length, textures);
    }

    public static void glBindVertexBuffers(int first, int[] buffers, PointerBuffer offsets, int[] strides) {
        long __functionAddress = GL.getCapabilities().glBindVertexBuffers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.length);
            }
            if (strides != null) {
                Checks.checkBuffer(strides, buffers.length);
            }
        }
        JNI.callPPPV(__functionAddress, first, buffers == null ? 0 : buffers.length, buffers, MemoryUtil.memAddressSafe(offsets), strides);
    }
}

