/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBSamplerObjects {
    public static final int GL_SAMPLER_BINDING = 35097;

    protected ARBSamplerObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGenSamplers, caps.glDeleteSamplers, caps.glIsSampler, caps.glBindSampler, caps.glSamplerParameteri, caps.glSamplerParameterf, caps.glSamplerParameteriv, caps.glSamplerParameterfv, caps.glSamplerParameterIiv, caps.glSamplerParameterIuiv, caps.glGetSamplerParameteriv, caps.glGetSamplerParameterfv, caps.glGetSamplerParameterIiv, caps.glGetSamplerParameterIuiv);
    }

    public static void nglGenSamplers(int count, long samplers) {
        long __functionAddress = GL.getCapabilities().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, count, samplers);
    }

    public static void glGenSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenSamplers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.callocInt(1);
            ARBSamplerObjects.nglGenSamplers(1, MemoryUtil.memAddress(samplers));
            int n = samplers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteSamplers(int count, long samplers) {
        long __functionAddress = GL.getCapabilities().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, count, samplers);
    }

    public static void glDeleteSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteSamplers(int sampler) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.ints(sampler);
            ARBSamplerObjects.nglDeleteSamplers(1, MemoryUtil.memAddress(samplers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsSampler(int sampler) {
        long __functionAddress = GL.getCapabilities().glIsSampler;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, sampler);
    }

    public static void glBindSampler(int unit, int sampler) {
        long __functionAddress = GL.getCapabilities().glBindSampler;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, unit, sampler);
    }

    public static void glSamplerParameteri(int sampler, int pname, int param) {
        long __functionAddress = GL.getCapabilities().glSamplerParameteri;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, sampler, pname, param);
    }

    public static void glSamplerParameterf(int sampler, int pname, float param) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterf;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, sampler, pname, param);
    }

    public static void nglSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameteri(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetSamplerParameterf(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIi(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSamplerParameterIui(int sampler, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenSamplers(int[] samplers) {
        long __functionAddress = GL.getCapabilities().glGenSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glDeleteSamplers(int[] samplers) {
        long __functionAddress = GL.getCapabilities().glDeleteSamplers;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, samplers.length, samplers);
    }

    public static void glSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameteriv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetSamplerParameterIuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, sampler, pname, params);
    }
}

