/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLAMDGPUAssociation {
    public static final int WGL_GPU_VENDOR_AMD = 7936;
    public static final int WGL_GPU_RENDERER_STRING_AMD = 7937;
    public static final int WGL_GPU_OPENGL_VERSION_STRING_AMD = 7938;
    public static final int WGL_GPU_FASTEST_TARGET_GPUS_AMD = 8610;
    public static final int WGL_GPU_RAM_AMD = 8611;
    public static final int WGL_GPU_CLOCK_AMD = 8612;
    public static final int WGL_GPU_NUM_PIPES_AMD = 8613;
    public static final int WGL_GPU_NUM_SIMD_AMD = 8614;
    public static final int WGL_GPU_NUM_RB_AMD = 8615;
    public static final int WGL_GPU_NUM_SPI_AMD = 8616;

    protected WGLAMDGPUAssociation() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(WGLCapabilities caps) {
        return Checks.checkFunctions(caps.wglGetGPUIDsAMD, caps.wglGetGPUInfoAMD, caps.wglGetContextGPUIDAMD, caps.wglCreateAssociatedContextAMD, caps.wglCreateAssociatedContextAttribsAMD, caps.wglDeleteAssociatedContextAMD, caps.wglMakeAssociatedContextCurrentAMD, caps.wglGetCurrentAssociatedContextAMD);
    }

    public static int nwglGetGPUIDsAMD(int maxCount, long ids) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetGPUIDsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, maxCount, ids);
    }

    public static int wglGetGPUIDsAMD(IntBuffer ids) {
        return WGLAMDGPUAssociation.nwglGetGPUIDsAMD(ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids));
    }

    public static int nwglGetGPUInfoAMD(int id, int property, int dataType, int size, long data) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetGPUInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, id, property, dataType, size, data);
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, ByteBuffer data) {
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, data.remaining() >> GLChecks.typeToByteShift(dataType), MemoryUtil.memAddress(data));
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, IntBuffer data) {
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, FloatBuffer data) {
        return WGLAMDGPUAssociation.nwglGetGPUInfoAMD(id, property, dataType, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static int wglGetContextGPUIDAMD(long hglrc) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetContextGPUIDAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hglrc);
        }
        return JNI.callPI(__functionAddress, hglrc);
    }

    public static long wglCreateAssociatedContextAMD(int id) {
        long __functionAddress = GL.getCapabilitiesWGL().wglCreateAssociatedContextAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress, id);
    }

    public static long nwglCreateAssociatedContextAttribsAMD(int id, long shareContext, long attribList) {
        long __functionAddress = GL.getCapabilitiesWGL().wglCreateAssociatedContextAttribsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPPP(__functionAddress, id, shareContext, attribList);
    }

    public static long wglCreateAssociatedContextAttribsAMD(int id, long shareContext, IntBuffer attribList) {
        if (Checks.CHECKS && attribList != null) {
            Checks.checkNT(attribList);
        }
        return WGLAMDGPUAssociation.nwglCreateAssociatedContextAttribsAMD(id, shareContext, MemoryUtil.memAddressSafe(attribList));
    }

    public static boolean wglDeleteAssociatedContextAMD(long hglrc) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDeleteAssociatedContextAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hglrc);
        }
        return JNI.callPI(__functionAddress, hglrc) != 0;
    }

    public static boolean wglMakeAssociatedContextCurrentAMD(long hglrc) {
        long __functionAddress = GL.getCapabilitiesWGL().wglMakeAssociatedContextCurrentAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hglrc);
        }
        return JNI.callPI(__functionAddress, hglrc) != 0;
    }

    public static long wglGetCurrentAssociatedContextAMD() {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetCurrentAssociatedContextAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callP(__functionAddress);
    }

    public static void wglBlitContextFramebufferAMD(long dstCtx, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = GL.getCapabilitiesWGL().wglBlitContextFramebufferAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dstCtx);
        }
        JNI.callPV(__functionAddress, dstCtx, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }

    public static int wglGetGPUIDsAMD(int[] ids) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetGPUIDsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, ids == null ? 0 : ids.length, ids);
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, int[] data) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetGPUInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, id, property, dataType, data.length << 2, data);
    }

    public static int wglGetGPUInfoAMD(int id, int property, int dataType, float[] data) {
        long __functionAddress = GL.getCapabilitiesWGL().wglGetGPUInfoAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, id, property, dataType, data.length << 2, data);
    }

    public static long wglCreateAssociatedContextAttribsAMD(int id, long shareContext, int[] attribList) {
        long __functionAddress = GL.getCapabilitiesWGL().wglCreateAssociatedContextAttribsAMD;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (attribList != null) {
                Checks.checkNT(attribList);
            }
        }
        return JNI.callPPP(__functionAddress, id, shareContext, attribList);
    }
}

