/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLNVSwapGroup {
    protected WGLNVSwapGroup() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(WGLCapabilities caps) {
        return Checks.checkFunctions(caps.wglJoinSwapGroupNV, caps.wglBindSwapBarrierNV, caps.wglQuerySwapGroupNV, caps.wglQueryMaxSwapGroupsNV, caps.wglQueryFrameCountNV, caps.wglResetFrameCountNV);
    }

    public static boolean wglJoinSwapGroupNV(long hDC, int group) {
        long __functionAddress = GL.getCapabilitiesWGL().wglJoinSwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
        }
        return JNI.callPI(__functionAddress, hDC, group) != 0;
    }

    public static boolean wglBindSwapBarrierNV(int group, int barrier) {
        long __functionAddress = GL.getCapabilitiesWGL().wglBindSwapBarrierNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, group, barrier) != 0;
    }

    public static int nwglQuerySwapGroupNV(long hDC, long group, long barrier) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
        }
        return JNI.callPPPI(__functionAddress, hDC, group, barrier);
    }

    public static boolean wglQuerySwapGroupNV(long hDC, IntBuffer group, IntBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)group, 1);
            Checks.checkBuffer((Buffer)barrier, 1);
        }
        return WGLNVSwapGroup.nwglQuerySwapGroupNV(hDC, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier)) != 0;
    }

    public static int nwglQueryMaxSwapGroupsNV(long hDC, long maxGroups, long maxBarriers) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
        }
        return JNI.callPPPI(__functionAddress, hDC, maxGroups, maxBarriers);
    }

    public static boolean wglQueryMaxSwapGroupsNV(long hDC, IntBuffer maxGroups, IntBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)maxGroups, 1);
            Checks.checkBuffer((Buffer)maxBarriers, 1);
        }
        return WGLNVSwapGroup.nwglQueryMaxSwapGroupsNV(hDC, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers)) != 0;
    }

    public static int nwglQueryFrameCountNV(long hDC, long count) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
        }
        return JNI.callPPI(__functionAddress, hDC, count);
    }

    public static boolean wglQueryFrameCountNV(long hDC, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return WGLNVSwapGroup.nwglQueryFrameCountNV(hDC, MemoryUtil.memAddress(count)) != 0;
    }

    public static boolean wglResetFrameCountNV(long hDC) {
        long __functionAddress = GL.getCapabilitiesWGL().wglResetFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
        }
        return JNI.callPI(__functionAddress, hDC) != 0;
    }

    public static boolean wglQuerySwapGroupNV(long hDC, int[] group, int[] barrier) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
            Checks.checkBuffer(group, 1);
            Checks.checkBuffer(barrier, 1);
        }
        return JNI.callPPPI(__functionAddress, hDC, group, barrier) != 0;
    }

    public static boolean wglQueryMaxSwapGroupsNV(long hDC, int[] maxGroups, int[] maxBarriers) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
            Checks.checkBuffer(maxGroups, 1);
            Checks.checkBuffer(maxBarriers, 1);
        }
        return JNI.callPPPI(__functionAddress, hDC, maxGroups, maxBarriers) != 0;
    }

    public static boolean wglQueryFrameCountNV(long hDC, int[] count) {
        long __functionAddress = GL.getCapabilitiesWGL().wglQueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hDC);
            Checks.checkBuffer(count, 1);
        }
        return JNI.callPPI(__functionAddress, hDC, count) != 0;
    }
}

