/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTBaseInstance {
    protected EXTBaseInstance() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysInstancedBaseInstanceEXT, caps.glDrawElementsInstancedBaseInstanceEXT, caps.glDrawElementsInstancedBaseVertexBaseInstanceEXT);
    }

    public static void glDrawArraysInstancedBaseInstanceEXT(int mode, int first, int count, int instancecount, int baseinstance) {
        long __functionAddress = GLES.getCapabilities().glDrawArraysInstancedBaseInstanceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, first, count, instancecount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseInstanceEXT(int mode, int count, int type, long indices, int instancecount, int baseinstance) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedBaseInstanceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, int count, int type, long indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, count, type, indices, instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, int type, ByteBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, ByteBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, ShortBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstanceEXT(int mode, IntBuffer indices, int instancecount, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseInstanceEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int count, int type, long indices, int instancecount, int basevertex, int baseinstance) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedBaseVertexBaseInstanceEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int count, int type, long indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, count, type, indices, instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, int type, ByteBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, ByteBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, ShortBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstanceEXT(int mode, IntBuffer indices, int instancecount, int basevertex, int baseinstance) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), instancecount, basevertex, baseinstance);
    }
}

