/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDebugMarker {
    protected EXTDebugMarker() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glInsertEventMarkerEXT, caps.glPushGroupMarkerEXT, caps.glPopGroupMarkerEXT);
    }

    public static void nglInsertEventMarkerEXT(int length, long marker) {
        long __functionAddress = GLES.getCapabilities().glInsertEventMarkerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, length, marker);
    }

    public static void glInsertEventMarkerEXT(ByteBuffer marker) {
        EXTDebugMarker.nglInsertEventMarkerEXT(marker.remaining(), MemoryUtil.memAddress(marker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glInsertEventMarkerEXT(CharSequence marker) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer markerEncoded = stack.UTF8(marker, false);
            int markerEncodedLen = markerEncoded.capacity();
            EXTDebugMarker.nglInsertEventMarkerEXT(markerEncodedLen, MemoryUtil.memAddress(markerEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglPushGroupMarkerEXT(int length, long marker) {
        long __functionAddress = GLES.getCapabilities().glPushGroupMarkerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, length, marker);
    }

    public static void glPushGroupMarkerEXT(ByteBuffer marker) {
        EXTDebugMarker.nglPushGroupMarkerEXT(marker.remaining(), MemoryUtil.memAddress(marker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushGroupMarkerEXT(CharSequence marker) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer markerEncoded = stack.UTF8(marker, false);
            int markerEncodedLen = markerEncoded.capacity();
            EXTDebugMarker.nglPushGroupMarkerEXT(markerEncodedLen, MemoryUtil.memAddress(markerEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glPopGroupMarkerEXT() {
        long __functionAddress = GLES.getCapabilities().glPopGroupMarkerEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress);
    }
}

