/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRGraphicsLuid
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    OVRGraphicsLuid(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRGraphicsLuid(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRGraphicsLuid.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer Reserved() {
        return OVRGraphicsLuid.nReserved(this.address());
    }

    public byte Reserved(int index) {
        return OVRGraphicsLuid.nReserved(this.address(), index);
    }

    public static OVRGraphicsLuid malloc() {
        return OVRGraphicsLuid.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRGraphicsLuid calloc() {
        return OVRGraphicsLuid.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRGraphicsLuid create() {
        return new OVRGraphicsLuid(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRGraphicsLuid create(long address) {
        return address == 0L ? null : new OVRGraphicsLuid(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRGraphicsLuid.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRGraphicsLuid.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRGraphicsLuid mallocStack() {
        return OVRGraphicsLuid.mallocStack(MemoryStack.stackGet());
    }

    public static OVRGraphicsLuid callocStack() {
        return OVRGraphicsLuid.callocStack(MemoryStack.stackGet());
    }

    public static OVRGraphicsLuid mallocStack(MemoryStack stack) {
        return OVRGraphicsLuid.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRGraphicsLuid callocStack(MemoryStack stack) {
        return OVRGraphicsLuid.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRGraphicsLuid.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRGraphicsLuid.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRGraphicsLuid.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRGraphicsLuid.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nReserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 8);
    }

    public static byte nReserved(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESERVED + (long)(index * 1));
    }

    static {
        Struct.Layout layout = OVRGraphicsLuid.__struct(OVRGraphicsLuid.__array(1, 8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static final class Buffer
    extends StructBuffer<OVRGraphicsLuid, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRGraphicsLuid newInstance(long address) {
            return new OVRGraphicsLuid(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer Reserved() {
            return OVRGraphicsLuid.nReserved(this.address());
        }

        public byte Reserved(int index) {
            return OVRGraphicsLuid.nReserved(this.address(), index);
        }
    }
}

