/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerEyeFov
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int FOV;
    public static final int RENDERPOSE;
    public static final int SENSORSAMPLETIME;

    OVRLayerEyeFov(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRLayerEyeFov(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRLayerEyeFov.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerEyeFov.nHeader(this.address());
    }

    public PointerBuffer ColorTexture() {
        return OVRLayerEyeFov.nColorTexture(this.address());
    }

    public long ColorTexture(int index) {
        return OVRLayerEyeFov.nColorTexture(this.address(), index);
    }

    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeFov.nViewport(this.address());
    }

    public OVRRecti Viewport(int index) {
        return OVRLayerEyeFov.nViewport(this.address(), index);
    }

    public OVRFovPort.Buffer Fov() {
        return OVRLayerEyeFov.nFov(this.address());
    }

    public OVRFovPort Fov(int index) {
        return OVRLayerEyeFov.nFov(this.address(), index);
    }

    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeFov.nRenderPose(this.address());
    }

    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeFov.nRenderPose(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeFov.nSensorSampleTime(this.address());
    }

    public OVRLayerEyeFov Header(OVRLayerHeader value) {
        OVRLayerEyeFov.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov ColorTexture(PointerBuffer value) {
        OVRLayerEyeFov.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov ColorTexture(int index, long value) {
        OVRLayerEyeFov.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Viewport(OVRRecti.Buffer value) {
        OVRLayerEyeFov.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Viewport(int index, OVRRecti value) {
        OVRLayerEyeFov.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov Fov(OVRFovPort.Buffer value) {
        OVRLayerEyeFov.nFov(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov Fov(int index, OVRFovPort value) {
        OVRLayerEyeFov.nFov(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov RenderPose(OVRPosef.Buffer value) {
        OVRLayerEyeFov.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov RenderPose(int index, OVRPosef value) {
        OVRLayerEyeFov.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeFov SensorSampleTime(double value) {
        OVRLayerEyeFov.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeFov set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRFovPort.Buffer Fov, OVRPosef.Buffer RenderPose, double SensorSampleTime) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.Fov(Fov);
        this.RenderPose(RenderPose);
        this.SensorSampleTime(SensorSampleTime);
        return this;
    }

    public OVRLayerEyeFov nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerEyeFov set(OVRLayerEyeFov src) {
        return this.nset(src.address());
    }

    public static OVRLayerEyeFov malloc() {
        return OVRLayerEyeFov.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerEyeFov calloc() {
        return OVRLayerEyeFov.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerEyeFov create() {
        return new OVRLayerEyeFov(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRLayerEyeFov create(long address) {
        return address == 0L ? null : new OVRLayerEyeFov(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRLayerEyeFov.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRLayerEyeFov.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRLayerEyeFov mallocStack() {
        return OVRLayerEyeFov.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeFov callocStack() {
        return OVRLayerEyeFov.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerEyeFov mallocStack(MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerEyeFov callocStack(MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeFov.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeFov.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeFov.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)COLORTEXTURE, 2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE + (long)(index * Integer.MAX_VALUE));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF));
    }

    public static OVRFovPort.Buffer nFov(long struct) {
        return OVRFovPort.create(struct + (long)FOV, 2);
    }

    public static OVRFovPort nFov(long struct, int index) {
        return OVRFovPort.create(struct + (long)FOV + (long)(index * OVRFovPort.SIZEOF));
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + (long)(index * OVRPosef.SIZEOF));
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)SENSORSAMPLETIME);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)COLORTEXTURE, value.remaining() * POINTER_SIZE);
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE + (long)(index * POINTER_SIZE), value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, value.remaining() * OVRRecti.SIZEOF);
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT + (long)(index * OVRRecti.SIZEOF), OVRRecti.SIZEOF);
    }

    public static void nFov(long struct, OVRFovPort.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, value.remaining() * OVRFovPort.SIZEOF);
    }

    public static void nFov(long struct, int index, OVRFovPort value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV + (long)(index * OVRFovPort.SIZEOF), OVRFovPort.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE, value.remaining() * OVRPosef.SIZEOF);
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERPOSE + (long)(index * OVRPosef.SIZEOF), OVRPosef.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)SENSORSAMPLETIME, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            OVRLayerEyeFov.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = OVRLayerEyeFov.__struct(OVRLayerEyeFov.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.ALIGNOF), OVRLayerEyeFov.__array(POINTER_SIZE, 2), OVRLayerEyeFov.__array(OVRRecti.SIZEOF, OVRRecti.ALIGNOF, 2), OVRLayerEyeFov.__array(OVRFovPort.SIZEOF, OVRFovPort.ALIGNOF, 2), OVRLayerEyeFov.__array(OVRPosef.SIZEOF, OVRPosef.ALIGNOF, 2), OVRLayerEyeFov.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        FOV = layout.offsetof(3);
        RENDERPOSE = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerEyeFov, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRLayerEyeFov newInstance(long address) {
            return new OVRLayerEyeFov(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerEyeFov.nHeader(this.address());
        }

        public PointerBuffer ColorTexture() {
            return OVRLayerEyeFov.nColorTexture(this.address());
        }

        public long ColorTexture(int index) {
            return OVRLayerEyeFov.nColorTexture(this.address(), index);
        }

        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeFov.nViewport(this.address());
        }

        public OVRRecti Viewport(int index) {
            return OVRLayerEyeFov.nViewport(this.address(), index);
        }

        public OVRFovPort.Buffer Fov() {
            return OVRLayerEyeFov.nFov(this.address());
        }

        public OVRFovPort Fov(int index) {
            return OVRLayerEyeFov.nFov(this.address(), index);
        }

        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeFov.nRenderPose(this.address());
        }

        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeFov.nRenderPose(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeFov.nSensorSampleTime(this.address());
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerEyeFov.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(PointerBuffer value) {
            OVRLayerEyeFov.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, long value) {
            OVRLayerEyeFov.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(OVRRecti.Buffer value) {
            OVRLayerEyeFov.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, OVRRecti value) {
            OVRLayerEyeFov.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Fov(OVRFovPort.Buffer value) {
            OVRLayerEyeFov.nFov(this.address(), value);
            return this;
        }

        public Buffer Fov(int index, OVRFovPort value) {
            OVRLayerEyeFov.nFov(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(OVRPosef.Buffer value) {
            OVRLayerEyeFov.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, OVRPosef value) {
            OVRLayerEyeFov.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeFov.nSensorSampleTime(this.address(), value);
            return this;
        }
    }
}

