/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRViewScaleDesc
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HMDTOEYEOFFSET;
    public static final int HMDSPACETOWORLDSCALEINMETERS;

    OVRViewScaleDesc(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRViewScaleDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRViewScaleDesc.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRVector3f.Buffer HmdToEyeOffset() {
        return OVRViewScaleDesc.nHmdToEyeOffset(this.address());
    }

    public OVRVector3f HmdToEyeOffset(int index) {
        return OVRViewScaleDesc.nHmdToEyeOffset(this.address(), index);
    }

    public float HmdSpaceToWorldScaleInMeters() {
        return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
    }

    public OVRViewScaleDesc HmdToEyeOffset(OVRVector3f.Buffer value) {
        OVRViewScaleDesc.nHmdToEyeOffset(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc HmdToEyeOffset(int index, OVRVector3f value) {
        OVRViewScaleDesc.nHmdToEyeOffset(this.address(), index, value);
        return this;
    }

    public OVRViewScaleDesc HmdSpaceToWorldScaleInMeters(float value) {
        OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc set(OVRVector3f.Buffer HmdToEyeOffset, float HmdSpaceToWorldScaleInMeters) {
        this.HmdToEyeOffset(HmdToEyeOffset);
        this.HmdSpaceToWorldScaleInMeters(HmdSpaceToWorldScaleInMeters);
        return this;
    }

    public OVRViewScaleDesc nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRViewScaleDesc set(OVRViewScaleDesc src) {
        return this.nset(src.address());
    }

    public static OVRViewScaleDesc malloc() {
        return OVRViewScaleDesc.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRViewScaleDesc calloc() {
        return OVRViewScaleDesc.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRViewScaleDesc create() {
        return new OVRViewScaleDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRViewScaleDesc create(long address) {
        return address == 0L ? null : new OVRViewScaleDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRViewScaleDesc.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRViewScaleDesc.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRViewScaleDesc mallocStack() {
        return OVRViewScaleDesc.mallocStack(MemoryStack.stackGet());
    }

    public static OVRViewScaleDesc callocStack() {
        return OVRViewScaleDesc.callocStack(MemoryStack.stackGet());
    }

    public static OVRViewScaleDesc mallocStack(MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRViewScaleDesc callocStack(MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRViewScaleDesc.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRViewScaleDesc.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRViewScaleDesc.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRVector3f.Buffer nHmdToEyeOffset(long struct) {
        return OVRVector3f.create(struct + (long)HMDTOEYEOFFSET, 2);
    }

    public static OVRVector3f nHmdToEyeOffset(long struct, int index) {
        return OVRVector3f.create(struct + (long)HMDTOEYEOFFSET + (long)(index * OVRVector3f.SIZEOF));
    }

    public static float nHmdSpaceToWorldScaleInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HMDSPACETOWORLDSCALEINMETERS);
    }

    public static void nHmdToEyeOffset(long struct, OVRVector3f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)HMDTOEYEOFFSET, value.remaining() * OVRVector3f.SIZEOF);
    }

    public static void nHmdToEyeOffset(long struct, int index, OVRVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HMDTOEYEOFFSET + (long)(index * OVRVector3f.SIZEOF), OVRVector3f.SIZEOF);
    }

    public static void nHmdSpaceToWorldScaleInMeters(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HMDSPACETOWORLDSCALEINMETERS, value);
    }

    static {
        Struct.Layout layout = OVRViewScaleDesc.__struct(OVRViewScaleDesc.__array(OVRVector3f.SIZEOF, OVRVector3f.ALIGNOF, 2), OVRViewScaleDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HMDTOEYEOFFSET = layout.offsetof(0);
        HMDSPACETOWORLDSCALEINMETERS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRViewScaleDesc, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRViewScaleDesc newInstance(long address) {
            return new OVRViewScaleDesc(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRVector3f.Buffer HmdToEyeOffset() {
            return OVRViewScaleDesc.nHmdToEyeOffset(this.address());
        }

        public OVRVector3f HmdToEyeOffset(int index) {
            return OVRViewScaleDesc.nHmdToEyeOffset(this.address(), index);
        }

        public float HmdSpaceToWorldScaleInMeters() {
            return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
        }

        public Buffer HmdToEyeOffset(OVRVector3f.Buffer value) {
            OVRViewScaleDesc.nHmdToEyeOffset(this.address(), value);
            return this;
        }

        public Buffer HmdToEyeOffset(int index, OVRVector3f value) {
            OVRViewScaleDesc.nHmdToEyeOffset(this.address(), index, value);
            return this;
        }

        public Buffer HmdSpaceToWorldScaleInMeters(float value) {
            OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
            return this;
        }
    }
}

