/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.stb.STBIWriteCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class STBImageWrite {
    public static final IntBuffer stbi_write_tga_with_rle;

    protected STBImageWrite() {
        throw new UnsupportedOperationException();
    }

    public static native int nstbi_write_png(long var0, int var2, int var3, int var4, long var5, int var7);

    public static int stbi_write_png(ByteBuffer filename, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_png(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_write_png(CharSequence filename, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImageWrite.nstbi_write_png(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_bmp(long var0, int var2, int var3, int var4, long var5);

    public static int stbi_write_bmp(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_bmp(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_write_bmp(CharSequence filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImageWrite.nstbi_write_bmp(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_tga(long var0, int var2, int var3, int var4, long var5);

    public static int stbi_write_tga(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_tga(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_write_tga(CharSequence filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImageWrite.nstbi_write_tga(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    private static native long nstbi_write_tga_with_rle();

    private static IntBuffer stbi_write_tga_with_rle() {
        long __result = STBImageWrite.nstbi_write_tga_with_rle();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    public static native int nstbi_write_hdr(long var0, int var2, int var3, int var4, long var5);

    public static int stbi_write_hdr(ByteBuffer filename, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_write_hdr(CharSequence filename, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_png_to_func(long var0, long var2, int var4, int var5, int var6, long var7, int var9);

    public static int stbi_write_png_to_func(STBIWriteCallbackI func, ByteBuffer context, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_png_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes);
    }

    public static native int nstbi_write_bmp_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static int stbi_write_bmp_to_func(STBIWriteCallbackI func, ByteBuffer context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_bmp_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_tga_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static int stbi_write_tga_to_func(STBIWriteCallbackI func, ByteBuffer context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_tga_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_hdr_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static int stbi_write_hdr_to_func(STBIWriteCallbackI func, ByteBuffer context, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_hdr(long var0, int var2, int var3, int var4, float[] var5);

    public static int stbi_write_hdr(ByteBuffer filename, int w, int h, int comp, float[] data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer(data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filename), w, h, comp, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stbi_write_hdr(CharSequence filename, int w, int h, int comp, float[] data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(data, w * h * comp);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            int n = STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filenameEncoded), w, h, comp, data);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_write_hdr_to_func(long var0, long var2, int var4, int var5, int var6, float[] var7);

    public static int stbi_write_hdr_to_func(STBIWriteCallbackI func, ByteBuffer context, int w, int h, int comp, float[] data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, data);
    }

    static {
        Library.initialize();
        MemoryUtil.getAllocator();
        stbi_write_tga_with_rle = STBImageWrite.stbi_write_tga_with_rle();
    }
}

