/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBTTPackContext
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    STBTTPackContext(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBTTPackContext(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), STBTTPackContext.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static STBTTPackContext malloc() {
        return STBTTPackContext.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTPackContext calloc() {
        return STBTTPackContext.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTPackContext create() {
        return new STBTTPackContext(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static STBTTPackContext create(long address) {
        return address == 0L ? null : new STBTTPackContext(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBTTPackContext.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTPackContext.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBTTPackContext mallocStack() {
        return STBTTPackContext.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTPackContext callocStack() {
        return STBTTPackContext.callocStack(MemoryStack.stackGet());
    }

    public static STBTTPackContext mallocStack(MemoryStack stack) {
        return STBTTPackContext.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTPackContext callocStack(MemoryStack stack) {
        return STBTTPackContext.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTPackContext.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTPackContext.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTPackContext.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTPackContext.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = STBTTPackContext.offsets(MemoryUtil.memAddress(offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static final class Buffer
    extends StructBuffer<STBTTPackContext, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected STBTTPackContext newInstance(long address) {
            return new STBTTPackContext(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }
    }
}

