/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;

class MemoryTextUtil {
    protected MemoryTextUtil() {
    }

    int encodeASCII(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int p = offset;
        int i = 0;
        while (i < text.length()) {
            target.put(p, (byte)text.charAt(i));
            ++i;
            ++p;
        }
        if (nullTerminated) {
            target.put(p++, (byte)0);
        }
        return p - offset;
    }

    static String decodeASCII(ByteBuffer buffer, int length, int offset) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)buffer.get(offset + i);
        }
        return new String(chars);
    }

    int encodeUTF8(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int c;
        int i;
        int len = text.length();
        int p = offset;
        for (i = 0; i < len && (c = text.charAt(i)) < 128; ++i) {
            target.put(p++, (byte)c);
        }
        while (i < len) {
            if ((c = text.charAt(i++)) < 128) {
                target.put(p++, (byte)c);
                continue;
            }
            int cp = c;
            if (c < 2048) {
                target.put(p++, (byte)(0xC0 | cp >> 6));
            } else {
                if (!Character.isHighSurrogate((char)c)) {
                    target.put(p++, (byte)(0xE0 | cp >> 12));
                } else {
                    cp = Character.toCodePoint((char)c, text.charAt(i++));
                    target.put(p++, (byte)(0xF0 | cp >> 18));
                    target.put(p++, (byte)(0x80 | cp >> 12 & 0x3F));
                }
                target.put(p++, (byte)(0x80 | cp >> 6 & 0x3F));
            }
            target.put(p++, (byte)(0x80 | cp & 0x3F));
        }
        if (nullTerminated) {
            target.put(p++, (byte)0);
        }
        return p - offset;
    }

    static int encodeUTF8Length(CharSequence value) {
        int i;
        int len;
        int bytes = len = value.length();
        for (i = 0; i < len && '\u0080' > value.charAt(i); ++i) {
        }
        while (i < len) {
            char c = value.charAt(i);
            if ('\u0800' <= c) {
                bytes += MemoryTextUtil.encodeUTF8LengthSlow(value, i, len);
                break;
            }
            bytes += 127 - c >>> 31;
            ++i;
        }
        return bytes;
    }

    private static int encodeUTF8LengthSlow(CharSequence value, int offset, int len) {
        int bytes = 0;
        for (int i = offset; i < len; ++i) {
            char c = value.charAt(i);
            if (c < '\u0800') {
                bytes += 127 - c >>> 31;
                continue;
            }
            if (c < '\ud800' || '\udfff' < c) {
                bytes += 2;
                continue;
            }
            if (Checks.DEBUG) {
                MemoryTextUtil.checkSurrogatePair(value, i, len);
            }
            bytes += 2;
            ++i;
        }
        return bytes;
    }

    private static void checkSurrogatePair(CharSequence value, int offset, int len) {
        char hi = value.charAt(offset);
        if (len <= offset) {
            throw new RuntimeException(String.format("Character sequence ends with single surrogate character: 0x%X", Character.valueOf(hi)));
        }
        char lo = value.charAt(offset + 1);
        if (!Character.isSurrogatePair(hi, lo)) {
            throw new RuntimeException(String.format("Malformed surrogate pair: 0x%X - 0x%X", Character.valueOf(hi), Character.valueOf(lo)));
        }
    }

    static String decodeUTF8(ByteBuffer buffer, int length, int offset) {
        byte c;
        int position;
        char[] string = new char[length];
        int i = 0;
        int limit = offset + length;
        for (position = offset; position < limit && (c = buffer.get(position)) >= 0; ++position) {
            string[i++] = (char)c;
        }
        while (position < limit) {
            byte b2;
            byte b1;
            byte b0;
            if (0 <= (b0 = buffer.get(position++))) {
                string[i++] = (char)b0;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                b1 = buffer.get(position++);
                if (Checks.DEBUG && (b1 & 0xC0) != 128) {
                    throw new RuntimeException("Malformed character sequence");
                }
                string[i++] = (char)(b0 << 6 ^ b1 ^ 0xF80);
                continue;
            }
            if (b0 >> 4 == -2) {
                b1 = buffer.get(position++);
                b2 = buffer.get(position++);
                if (Checks.DEBUG && MemoryTextUtil.isMalformed3(b0, b1, b2)) {
                    throw new RuntimeException("Malformed character sequence");
                }
                char c2 = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                if (Checks.DEBUG && '\ud800' <= c2 && c2 <= '\udfff') {
                    throw new RuntimeException("Malformed character sequence");
                }
                string[i++] = c2;
                continue;
            }
            if (b0 >> 3 == -2) {
                b1 = buffer.get(position++);
                b2 = buffer.get(position++);
                byte b3 = buffer.get(position++);
                int cp = b0 << 18 ^ b1 << 12 ^ b2 << 6 ^ (b3 ^ 0x381F80);
                if (Checks.DEBUG && (MemoryTextUtil.isMalformed4(b1, b2, b3) || !Character.isSupplementaryCodePoint(cp))) {
                    throw new RuntimeException("Malformed character sequence");
                }
                string[i++] = (char)((cp >>> 10) + 55296 - 64);
                string[i++] = (char)((cp & 0x3FF) + 56320);
                continue;
            }
            if (!Checks.DEBUG) continue;
            throw new RuntimeException("Malformed character sequence");
        }
        return new String(string, 0, i);
    }

    private static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }

    int encodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target, int offset) {
        int p = offset;
        int i = 0;
        while (i < text.length()) {
            target.putChar(p, text.charAt(i));
            ++i;
            p += 2;
        }
        if (nullTerminated) {
            target.putChar(p, '\u0000');
            p += 2;
        }
        return p - offset;
    }

    static String decodeUTF16(ByteBuffer buffer, int length, int offset) {
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = buffer.getChar(offset + (i << 1));
        }
        return new String(chars);
    }
}

