/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import java.util.zip.CRC32;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.Platform;

final class SharedLibraryLoader {
    private static final int BUFFER_SIZE = 8192;
    private static File extractPath;

    private SharedLibraryLoader() {
    }

    static void load() {
        try {
            extractPath = SharedLibraryLoader.extractFile(Platform.get().mapLibraryName(Library.JNI_LIBRARY_NAME), null).getParentFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to extract the LWJGL shared library", e);
        }
        String libraryPath = Configuration.LIBRARY_PATH.get();
        libraryPath = libraryPath == null || libraryPath.isEmpty() ? extractPath.getAbsolutePath() : extractPath.getAbsolutePath() + File.pathSeparator + libraryPath;
        System.setProperty(Configuration.LIBRARY_PATH.getProperty(), libraryPath);
        Configuration.LIBRARY_PATH.set(libraryPath);
    }

    static void load(String library) {
        if (Library.JNI_LIBRARY_NAME.equals(library)) {
            SharedLibraryLoader.load();
            return;
        }
        try {
            SharedLibraryLoader.extractFile(Platform.get().mapLibraryName(library), extractPath);
        }
        catch (Exception e) {
            throw new RuntimeException("\tFailed to extract " + library + " library", e);
        }
    }

    private static File extractFile(String libraryFile, File libraryPath) throws IOException {
        String libraryCRC;
        URL resource = SharedLibraryLoader.class.getResource("/" + libraryFile);
        if (resource == null) {
            throw new RuntimeException("Failed to locate resource: " + libraryFile);
        }
        APIUtil.apiLog(String.format("\tExtracting: %s", resource.getPath()));
        try (InputStream input = resource.openStream();){
            libraryCRC = SharedLibraryLoader.crc(input);
        }
        File extractedFile = SharedLibraryLoader.getExtractedFile(libraryPath == null ? new File(libraryCRC) : libraryPath, new File(libraryFile).getName());
        SharedLibraryLoader.extractFile(resource, libraryCRC, extractedFile);
        return extractedFile;
    }

    private static File getExtractedFile(File libraryPath, String fileName) {
        if (libraryPath.isDirectory()) {
            return new File(libraryPath, fileName);
        }
        if (Configuration.SHARED_LIBRARY_EXTRACT_PATH.get() != null) {
            return new File(Configuration.SHARED_LIBRARY_EXTRACT_PATH.get(), fileName);
        }
        String tempDirectory = Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl" + System.getProperty("user.name"));
        File file = new File(System.getProperty("java.io.tmpdir") + "/" + tempDirectory + "/" + libraryPath, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        tempDirectory = Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl");
        file = new File(System.getProperty("user.home") + "/." + tempDirectory + "/" + libraryPath, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        file = new File("." + tempDirectory + "/" + libraryPath, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        try {
            file = File.createTempFile(libraryPath.getName(), null);
            if (file.delete() && SharedLibraryLoader.canWrite(file = new File(file, fileName))) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Failed to find an appropriate directory to extract the native library");
    }

    private static void extractFile(URL resource, String libraryCRC, File extractedFile) throws IOException {
        Throwable throwable;
        InputStream input;
        String extractedCrc = null;
        if (extractedFile.exists()) {
            input = new FileInputStream(extractedFile);
            throwable = null;
            try {
                extractedCrc = SharedLibraryLoader.crc(input);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input != null) {
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        if (extractedCrc == null || !extractedCrc.equals(libraryCRC)) {
            extractedFile.getParentFile().mkdirs();
            input = resource.openStream();
            throwable = null;
            try (FileOutputStream output = new FileOutputStream(extractedFile);){
                int n;
                byte[] buffer = new byte[8192];
                while ((n = input.read(buffer)) > 0) {
                    output.write(buffer, 0, n);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (input != null) {
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
    }

    private static String crc(InputStream input) throws IOException {
        int n;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((n = input.read(buffer)) > 0) {
            crc.update(buffer, 0, n);
        }
        return Long.toHexString(crc.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        File testFile;
        File parent = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !SharedLibraryLoader.canExecute(file)) {
                return false;
            }
            testFile = new File(parent, UUID.randomUUID().toString());
        } else {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                return false;
            }
            testFile = file;
        }
        try {
            new FileOutputStream(testFile).close();
            boolean bl = SharedLibraryLoader.canExecute(testFile);
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            testFile.delete();
        }
    }

    private static boolean canExecute(File file) {
        try {
            if (file.canExecute()) {
                return true;
            }
            file.setExecutable(true, false);
            return file.canExecute();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

