/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class JAWTWin32DrawingSurfaceInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HWND;
    public static final int HBITMAP;
    public static final int PBITS;
    public static final int HDC;
    public static final int HPALETTE;

    JAWTWin32DrawingSurfaceInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public JAWTWin32DrawingSurfaceInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), JAWTWin32DrawingSurfaceInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long hwnd() {
        return JAWTWin32DrawingSurfaceInfo.nhwnd(this.address());
    }

    public long hbitmap() {
        return JAWTWin32DrawingSurfaceInfo.nhbitmap(this.address());
    }

    public ByteBuffer pbits(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.npbits(this.address(), capacity);
    }

    public long hdc() {
        return JAWTWin32DrawingSurfaceInfo.nhdc(this.address());
    }

    public long hpalette() {
        return JAWTWin32DrawingSurfaceInfo.nhpalette(this.address());
    }

    public static JAWTWin32DrawingSurfaceInfo malloc() {
        return JAWTWin32DrawingSurfaceInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static JAWTWin32DrawingSurfaceInfo calloc() {
        return JAWTWin32DrawingSurfaceInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static JAWTWin32DrawingSurfaceInfo create() {
        return new JAWTWin32DrawingSurfaceInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static JAWTWin32DrawingSurfaceInfo create(long address) {
        return address == 0L ? null : new JAWTWin32DrawingSurfaceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static JAWTWin32DrawingSurfaceInfo mallocStack() {
        return JAWTWin32DrawingSurfaceInfo.mallocStack(MemoryStack.stackGet());
    }

    public static JAWTWin32DrawingSurfaceInfo callocStack() {
        return JAWTWin32DrawingSurfaceInfo.callocStack(MemoryStack.stackGet());
    }

    public static JAWTWin32DrawingSurfaceInfo mallocStack(MemoryStack stack) {
        return JAWTWin32DrawingSurfaceInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static JAWTWin32DrawingSurfaceInfo callocStack(MemoryStack stack) {
        return JAWTWin32DrawingSurfaceInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return JAWTWin32DrawingSurfaceInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return JAWTWin32DrawingSurfaceInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return JAWTWin32DrawingSurfaceInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhwnd(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HWND);
    }

    public static long nhbitmap(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HBITMAP);
    }

    public static ByteBuffer npbits(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PBITS), capacity);
    }

    public static long nhdc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HDC);
    }

    public static long nhpalette(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HPALETTE);
    }

    static {
        Struct.Layout layout = JAWTWin32DrawingSurfaceInfo.__struct(JAWTWin32DrawingSurfaceInfo.__union(JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE)), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTWin32DrawingSurfaceInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HWND = layout.offsetof(1);
        HBITMAP = layout.offsetof(2);
        PBITS = layout.offsetof(3);
        HDC = layout.offsetof(4);
        HPALETTE = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<JAWTWin32DrawingSurfaceInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected JAWTWin32DrawingSurfaceInfo newInstance(long address) {
            return new JAWTWin32DrawingSurfaceInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long hwnd() {
            return JAWTWin32DrawingSurfaceInfo.nhwnd(this.address());
        }

        public long hbitmap() {
            return JAWTWin32DrawingSurfaceInfo.nhbitmap(this.address());
        }

        public ByteBuffer pbits(int capacity) {
            return JAWTWin32DrawingSurfaceInfo.npbits(this.address(), capacity);
        }

        public long hdc() {
            return JAWTWin32DrawingSurfaceInfo.nhdc(this.address());
        }

        public long hpalette() {
            return JAWTWin32DrawingSurfaceInfo.nhpalette(this.address());
        }
    }
}

