/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ObjCPropertyAttribute
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int VALUE;

    ObjCPropertyAttribute(long address, ByteBuffer container) {
        super(address, container);
    }

    public ObjCPropertyAttribute(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), ObjCPropertyAttribute.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer name() {
        return ObjCPropertyAttribute.nname(this.address());
    }

    public String nameString() {
        return ObjCPropertyAttribute.nnameString(this.address());
    }

    public ByteBuffer value() {
        return ObjCPropertyAttribute.nvalue(this.address());
    }

    public String valueString() {
        return ObjCPropertyAttribute.nvalueString(this.address());
    }

    public ObjCPropertyAttribute name(ByteBuffer value) {
        ObjCPropertyAttribute.nname(this.address(), value);
        return this;
    }

    public ObjCPropertyAttribute value(ByteBuffer value) {
        ObjCPropertyAttribute.nvalue(this.address(), value);
        return this;
    }

    public ObjCPropertyAttribute set(ByteBuffer name, ByteBuffer value) {
        this.name(name);
        this.value(value);
        return this;
    }

    public ObjCPropertyAttribute nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public ObjCPropertyAttribute set(ObjCPropertyAttribute src) {
        return this.nset(src.address());
    }

    public static ObjCPropertyAttribute malloc() {
        return ObjCPropertyAttribute.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static ObjCPropertyAttribute calloc() {
        return ObjCPropertyAttribute.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static ObjCPropertyAttribute create() {
        return new ObjCPropertyAttribute(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static ObjCPropertyAttribute create(long address) {
        return address == 0L ? null : new ObjCPropertyAttribute(address, null);
    }

    public static Buffer malloc(int capacity) {
        return ObjCPropertyAttribute.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ObjCPropertyAttribute.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static ObjCPropertyAttribute mallocStack() {
        return ObjCPropertyAttribute.mallocStack(MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute callocStack() {
        return ObjCPropertyAttribute.callocStack(MemoryStack.stackGet());
    }

    public static ObjCPropertyAttribute mallocStack(MemoryStack stack) {
        return ObjCPropertyAttribute.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ObjCPropertyAttribute callocStack(MemoryStack stack) {
        return ObjCPropertyAttribute.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return ObjCPropertyAttribute.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return ObjCPropertyAttribute.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ObjCPropertyAttribute.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ObjCPropertyAttribute.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer nvalue(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    public static String nvalueString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS && value != null) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void nvalue(long struct, ByteBuffer value) {
        if (Checks.CHECKS && value != null) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)VALUE, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)NAME));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)VALUE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            ObjCPropertyAttribute.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = ObjCPropertyAttribute.__struct(ObjCPropertyAttribute.__member(POINTER_SIZE), ObjCPropertyAttribute.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        VALUE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<ObjCPropertyAttribute, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected ObjCPropertyAttribute newInstance(long address) {
            return new ObjCPropertyAttribute(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer name() {
            return ObjCPropertyAttribute.nname(this.address());
        }

        public String nameString() {
            return ObjCPropertyAttribute.nnameString(this.address());
        }

        public ByteBuffer value() {
            return ObjCPropertyAttribute.nvalue(this.address());
        }

        public String valueString() {
            return ObjCPropertyAttribute.nvalueString(this.address());
        }

        public Buffer name(ByteBuffer value) {
            ObjCPropertyAttribute.nname(this.address(), value);
            return this;
        }

        public Buffer value(ByteBuffer value) {
            ObjCPropertyAttribute.nvalue(this.address(), value);
            return this;
        }
    }
}

