/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.nfd.NFDPathSet;

public class NativeFileDialog {
    public static final int NFD_ERROR = 0;
    public static final int NFD_OKAY = 1;
    public static final int NFD_CANCEL = 2;

    protected NativeFileDialog() {
        throw new UnsupportedOperationException();
    }

    public static native int nNFD_OpenDialog(long var0, long var2, long var4);

    public static int NFD_OpenDialog(ByteBuffer filterList, ByteBuffer defaultPath, PointerBuffer outPath) {
        if (Checks.CHECKS) {
            if (filterList != null) {
                Checks.checkNT1(filterList);
            }
            if (defaultPath != null) {
                Checks.checkNT1(defaultPath);
            }
            Checks.checkBuffer(outPath, 1);
        }
        return NativeFileDialog.nNFD_OpenDialog(MemoryUtil.memAddressSafe(filterList), MemoryUtil.memAddressSafe(defaultPath), MemoryUtil.memAddress(outPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int NFD_OpenDialog(CharSequence filterList, CharSequence defaultPath, PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(outPath, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filterListEncoded = stack.UTF8(filterList);
            ByteBuffer defaultPathEncoded = stack.UTF8(defaultPath);
            int n = NativeFileDialog.nNFD_OpenDialog(MemoryUtil.memAddressSafe(filterListEncoded), MemoryUtil.memAddressSafe(defaultPathEncoded), MemoryUtil.memAddress(outPath));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nNFD_OpenDialogMultiple(long var0, long var2, long var4);

    public static int NFD_OpenDialogMultiple(ByteBuffer filterList, ByteBuffer defaultPath, NFDPathSet outPaths) {
        if (Checks.CHECKS) {
            if (filterList != null) {
                Checks.checkNT1(filterList);
            }
            if (defaultPath != null) {
                Checks.checkNT1(defaultPath);
            }
        }
        return NativeFileDialog.nNFD_OpenDialogMultiple(MemoryUtil.memAddressSafe(filterList), MemoryUtil.memAddressSafe(defaultPath), outPaths.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int NFD_OpenDialogMultiple(CharSequence filterList, CharSequence defaultPath, NFDPathSet outPaths) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filterListEncoded = stack.UTF8(filterList);
            ByteBuffer defaultPathEncoded = stack.UTF8(defaultPath);
            int n = NativeFileDialog.nNFD_OpenDialogMultiple(MemoryUtil.memAddressSafe(filterListEncoded), MemoryUtil.memAddressSafe(defaultPathEncoded), outPaths.address());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nNFD_SaveDialog(long var0, long var2, long var4);

    public static int NFD_SaveDialog(ByteBuffer filterList, ByteBuffer defaultPath, PointerBuffer outPath) {
        if (Checks.CHECKS) {
            if (filterList != null) {
                Checks.checkNT1(filterList);
            }
            if (defaultPath != null) {
                Checks.checkNT1(defaultPath);
            }
            Checks.checkBuffer(outPath, 1);
        }
        return NativeFileDialog.nNFD_SaveDialog(MemoryUtil.memAddressSafe(filterList), MemoryUtil.memAddressSafe(defaultPath), MemoryUtil.memAddress(outPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int NFD_SaveDialog(CharSequence filterList, CharSequence defaultPath, PointerBuffer outPath) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(outPath, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filterListEncoded = stack.UTF8(filterList);
            ByteBuffer defaultPathEncoded = stack.UTF8(defaultPath);
            int n = NativeFileDialog.nNFD_SaveDialog(MemoryUtil.memAddressSafe(filterListEncoded), MemoryUtil.memAddressSafe(defaultPathEncoded), MemoryUtil.memAddress(outPath));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nNFD_GetError();

    public static String NFD_GetError() {
        long __result = NativeFileDialog.nNFD_GetError();
        return MemoryUtil.memASCII(__result);
    }

    public static native long nNFD_PathSet_GetCount(long var0);

    public static long NFD_PathSet_GetCount(NFDPathSet pathSet) {
        return NativeFileDialog.nNFD_PathSet_GetCount(pathSet.address());
    }

    public static native long nNFD_PathSet_GetPath(long var0, long var2);

    public static String NFD_PathSet_GetPath(NFDPathSet pathSet, long index) {
        long __result = NativeFileDialog.nNFD_PathSet_GetPath(pathSet.address(), index);
        return MemoryUtil.memUTF8(__result);
    }

    public static native void nNFD_PathSet_Free(long var0);

    public static void NFD_PathSet_Free(NFDPathSet pathSet) {
        NativeFileDialog.nNFD_PathSet_Free(pathSet.address());
    }

    public static native void nNFD_Free(long var0);

    public static void NFD_Free(ByteBuffer outPath) {
        NativeFileDialog.nNFD_Free(MemoryUtil.memAddress(outPath));
    }

    static {
        Library.initialize();
        MemoryUtil.getAllocator();
    }
}

