/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.par.ParShapesMesh;

public class ParShapes {
    protected ParShapes() {
        throw new UnsupportedOperationException();
    }

    public static native void npar_shapes_free_mesh(long var0);

    public static void par_shapes_free_mesh(ParShapesMesh mesh) {
        ParShapes.npar_shapes_free_mesh(mesh.address());
    }

    public static native long npar_shapes_create_cylinder(int var0, int var1);

    public static ParShapesMesh par_shapes_create_cylinder(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_cylinder(slices, stacks);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_torus(int var0, int var1, float var2);

    public static ParShapesMesh par_shapes_create_torus(int slices, int stacks, float radius) {
        long __result = ParShapes.npar_shapes_create_torus(slices, stacks, radius);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_parametric_sphere(int var0, int var1);

    public static ParShapesMesh par_shapes_create_parametric_sphere(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_parametric_sphere(slices, stacks);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_subdivided_sphere(int var0);

    public static ParShapesMesh par_shapes_create_subdivided_sphere(int nsubdivisions) {
        long __result = ParShapes.npar_shapes_create_subdivided_sphere(nsubdivisions);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_klein_bottle(int var0, int var1);

    public static ParShapesMesh par_shapes_create_klein_bottle(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_klein_bottle(slices, stacks);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_trefoil_knot(int var0, int var1, float var2);

    public static ParShapesMesh par_shapes_create_trefoil_knot(int slices, int stacks, float radius) {
        long __result = ParShapes.npar_shapes_create_trefoil_knot(slices, stacks, radius);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_hemisphere(int var0, int var1);

    public static ParShapesMesh par_shapes_create_hemisphere(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_hemisphere(slices, stacks);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_plane(int var0, int var1);

    public static ParShapesMesh par_shapes_create_plane(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_plane(slices, stacks);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_icosahedron();

    public static ParShapesMesh par_shapes_create_icosahedron() {
        long __result = ParShapes.npar_shapes_create_icosahedron();
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_dodecahedron();

    public static ParShapesMesh par_shapes_create_dodecahedron() {
        long __result = ParShapes.npar_shapes_create_dodecahedron();
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_octohedron();

    public static ParShapesMesh par_shapes_create_octohedron() {
        long __result = ParShapes.npar_shapes_create_octohedron();
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_tetrahedron();

    public static ParShapesMesh par_shapes_create_tetrahedron() {
        long __result = ParShapes.npar_shapes_create_tetrahedron();
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_cube();

    public static ParShapesMesh par_shapes_create_cube() {
        long __result = ParShapes.npar_shapes_create_cube();
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_disk(float var0, int var1, long var2, long var4);

    public static ParShapesMesh par_shapes_create_disk(float radius, int slices, FloatBuffer center, FloatBuffer normal) {
        long __result = ParShapes.npar_shapes_create_disk(radius, slices, MemoryUtil.memAddress(center), MemoryUtil.memAddress(normal));
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_empty();

    public static ParShapesMesh par_shapes_create_empty() {
        long __result = ParShapes.npar_shapes_create_empty();
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_rock(int var0, int var1);

    public static ParShapesMesh par_shapes_create_rock(int seed, int nsubdivisions) {
        long __result = ParShapes.npar_shapes_create_rock(seed, nsubdivisions);
        return ParShapesMesh.create(__result);
    }

    public static native long npar_shapes_create_lsystem(long var0, int var2, int var3);

    public static ParShapesMesh par_shapes_create_lsystem(ByteBuffer program, int slices, int maxdepth) {
        if (Checks.CHECKS) {
            Checks.checkNT1(program);
        }
        long __result = ParShapes.npar_shapes_create_lsystem(MemoryUtil.memAddress(program), slices, maxdepth);
        return ParShapesMesh.create(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParShapesMesh par_shapes_create_lsystem(CharSequence program, int slices, int maxdepth) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer programEncoded = stack.ASCII(program);
            long __result = ParShapes.npar_shapes_create_lsystem(MemoryUtil.memAddress(programEncoded), slices, maxdepth);
            ParShapesMesh parShapesMesh = ParShapesMesh.create(__result);
            return parShapesMesh;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void npar_shapes_export(long var0, long var2);

    public static void par_shapes_export(ParShapesMesh mesh, ByteBuffer objfile) {
        if (Checks.CHECKS) {
            Checks.checkNT1(objfile);
        }
        ParShapes.npar_shapes_export(mesh.address(), MemoryUtil.memAddress(objfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void par_shapes_export(ParShapesMesh mesh, CharSequence objfile) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer objfileEncoded = stack.ASCII(objfile);
            ParShapes.npar_shapes_export(mesh.address(), MemoryUtil.memAddress(objfileEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void npar_shapes_compute_aabb(long var0, long var2);

    public static void par_shapes_compute_aabb(ParShapesMesh mesh, FloatBuffer aabb) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)aabb, 6);
        }
        ParShapes.npar_shapes_compute_aabb(mesh.address(), MemoryUtil.memAddress(aabb));
    }

    public static native long npar_shapes_clone(long var0, long var2);

    public static ParShapesMesh par_shapes_clone(ParShapesMesh mesh, ParShapesMesh target) {
        long __result = ParShapes.npar_shapes_clone(mesh.address(), target == null ? 0L : target.address());
        return ParShapesMesh.create(__result);
    }

    public static native void npar_shapes_merge(long var0, long var2);

    public static void par_shapes_merge(ParShapesMesh dst, ParShapesMesh src) {
        ParShapes.npar_shapes_merge(dst.address(), src.address());
    }

    public static native void npar_shapes_translate(long var0, float var2, float var3, float var4);

    public static void par_shapes_translate(ParShapesMesh mesh, float x, float y, float z) {
        ParShapes.npar_shapes_translate(mesh.address(), x, y, z);
    }

    public static native void npar_shapes_rotate(long var0, float var2, long var3);

    public static void par_shapes_rotate(ParShapesMesh mesh, float radians, FloatBuffer axis) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)axis, 3);
        }
        ParShapes.npar_shapes_rotate(mesh.address(), radians, MemoryUtil.memAddress(axis));
    }

    public static native void npar_shapes_scale(long var0, float var2, float var3, float var4);

    public static void par_shapes_scale(ParShapesMesh mesh, float x, float y, float z) {
        ParShapes.npar_shapes_scale(mesh.address(), x, y, z);
    }

    public static native void npar_shapes_merge_and_free(long var0, long var2);

    public static void par_shapes_merge_and_free(ParShapesMesh dst, ParShapesMesh src) {
        ParShapes.npar_shapes_merge_and_free(dst.address(), src.address());
    }

    public static native void npar_shapes_invert(long var0, int var2, int var3);

    public static void par_shapes_invert(ParShapesMesh mesh, int startface, int nfaces) {
        ParShapes.npar_shapes_invert(mesh.address(), startface, nfaces);
    }

    public static native void npar_shapes_remove_degenerate(long var0, float var2);

    public static void par_shapes_remove_degenerate(ParShapesMesh mesh, float minarea) {
        ParShapes.npar_shapes_remove_degenerate(mesh.address(), minarea);
    }

    public static native void npar_shapes_unweld(long var0, boolean var2);

    public static void par_shapes_unweld(ParShapesMesh mesh, boolean create_indices) {
        ParShapes.npar_shapes_unweld(mesh.address(), create_indices);
    }

    public static native long npar_shapes_weld(long var0, float var2, long var3);

    public static ParShapesMesh par_shapes_weld(ParShapesMesh mesh, float epsilon, ShortBuffer mapping) {
        long __result = ParShapes.npar_shapes_weld(mesh.address(), epsilon, MemoryUtil.memAddressSafe(mapping));
        return ParShapesMesh.create(__result);
    }

    public static native void npar_shapes_compute_normals(long var0);

    public static void par_shapes_compute_normals(ParShapesMesh mesh) {
        ParShapes.npar_shapes_compute_normals(mesh.address());
    }

    public static native long npar_shapes_create_disk(float var0, int var1, float[] var2, float[] var3);

    public static ParShapesMesh par_shapes_create_disk(float radius, int slices, float[] center, float[] normal) {
        long __result = ParShapes.npar_shapes_create_disk(radius, slices, center, normal);
        return ParShapesMesh.create(__result);
    }

    public static native void npar_shapes_compute_aabb(long var0, float[] var2);

    public static void par_shapes_compute_aabb(ParShapesMesh mesh, float[] aabb) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(aabb, 6);
        }
        ParShapes.npar_shapes_compute_aabb(mesh.address(), aabb);
    }

    public static native void npar_shapes_rotate(long var0, float var2, float[] var3);

    public static void par_shapes_rotate(ParShapesMesh mesh, float radians, float[] axis) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(axis, 3);
        }
        ParShapes.npar_shapes_rotate(mesh.address(), radians, axis);
    }

    public static native long npar_shapes_weld(long var0, float var2, short[] var3);

    public static ParShapesMesh par_shapes_weld(ParShapesMesh mesh, float epsilon, short[] mapping) {
        long __result = ParShapes.npar_shapes_weld(mesh.address(), epsilon, mapping);
        return ParShapesMesh.create(__result);
    }

    static {
        Library.initialize();
        MemoryUtil.getAllocator();
    }
}

