/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VKCapabilities;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkXlibSurfaceCreateInfoKHR;

public class KHRXlibSurface {
    public static final int VK_KHR_XLIB_SURFACE_SPEC_VERSION = 6;
    public static final String VK_KHR_XLIB_SURFACE_EXTENSION_NAME = "VK_KHR_xlib_surface";
    public static final int VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR = 1000004000;

    protected KHRXlibSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(VKCapabilities caps) {
        return Checks.checkFunctions(caps.vkCreateXlibSurfaceKHR, caps.vkGetPhysicalDeviceXlibPresentationSupportKHR);
    }

    public static int nvkCreateXlibSurfaceKHR(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateXlibSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            VkXlibSurfaceCreateInfoKHR.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo, pAllocator, pSurface);
    }

    public static int vkCreateXlibSurfaceKHR(VkInstance instance, VkXlibSurfaceCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pSurface, 1);
        }
        return KHRXlibSurface.nvkCreateXlibSurfaceKHR(instance, pCreateInfo.address(), pAllocator == null ? 0L : pAllocator.address(), MemoryUtil.memAddress(pSurface));
    }

    public static int vkGetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, int queueFamilyIndex, long dpy, long visualID) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceXlibPresentationSupportKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPI(__functionAddress, physicalDevice.address(), queueFamilyIndex, dpy, visualID);
    }

    public static int vkCreateXlibSurfaceKHR(VkInstance instance, VkXlibSurfaceCreateInfoKHR pCreateInfo, VkAllocationCallbacks pAllocator, long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateXlibSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(pSurface, 1);
            VkXlibSurfaceCreateInfoKHR.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI(__functionAddress, instance.address(), pCreateInfo.address(), pAllocator == null ? 0L : pAllocator.address(), pSurface);
    }
}

