/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferViewCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BUFFER;
    public static final int FORMAT;
    public static final int OFFSET;
    public static final int RANGE;

    VkBufferViewCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkBufferViewCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkBufferViewCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkBufferViewCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkBufferViewCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkBufferViewCreateInfo.nflags(this.address());
    }

    public long buffer() {
        return VkBufferViewCreateInfo.nbuffer(this.address());
    }

    public int format() {
        return VkBufferViewCreateInfo.nformat(this.address());
    }

    public long offset() {
        return VkBufferViewCreateInfo.noffset(this.address());
    }

    public long range() {
        return VkBufferViewCreateInfo.nrange(this.address());
    }

    public VkBufferViewCreateInfo sType(int value) {
        VkBufferViewCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo pNext(long value) {
        VkBufferViewCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo flags(int value) {
        VkBufferViewCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo buffer(long value) {
        VkBufferViewCreateInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo format(int value) {
        VkBufferViewCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo offset(long value) {
        VkBufferViewCreateInfo.noffset(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo range(long value) {
        VkBufferViewCreateInfo.nrange(this.address(), value);
        return this;
    }

    public VkBufferViewCreateInfo set(int sType, long pNext, int flags, long buffer, int format, long offset, long range) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.buffer(buffer);
        this.format(format);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public VkBufferViewCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkBufferViewCreateInfo set(VkBufferViewCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkBufferViewCreateInfo malloc() {
        return VkBufferViewCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkBufferViewCreateInfo calloc() {
        return VkBufferViewCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkBufferViewCreateInfo create() {
        return new VkBufferViewCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkBufferViewCreateInfo create(long address) {
        return address == 0L ? null : new VkBufferViewCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferViewCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferViewCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkBufferViewCreateInfo mallocStack() {
        return VkBufferViewCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferViewCreateInfo callocStack() {
        return VkBufferViewCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferViewCreateInfo mallocStack(MemoryStack stack) {
        return VkBufferViewCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferViewCreateInfo callocStack(MemoryStack stack) {
        return VkBufferViewCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferViewCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferViewCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferViewCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferViewCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RANGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = VkBufferViewCreateInfo.__struct(VkBufferViewCreateInfo.__member(4), VkBufferViewCreateInfo.__member(POINTER_SIZE), VkBufferViewCreateInfo.__member(4), VkBufferViewCreateInfo.__member(8), VkBufferViewCreateInfo.__member(4), VkBufferViewCreateInfo.__member(8), VkBufferViewCreateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BUFFER = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
        OFFSET = layout.offsetof(5);
        RANGE = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<VkBufferViewCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkBufferViewCreateInfo newInstance(long address) {
            return new VkBufferViewCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkBufferViewCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkBufferViewCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkBufferViewCreateInfo.nflags(this.address());
        }

        public long buffer() {
            return VkBufferViewCreateInfo.nbuffer(this.address());
        }

        public int format() {
            return VkBufferViewCreateInfo.nformat(this.address());
        }

        public long offset() {
            return VkBufferViewCreateInfo.noffset(this.address());
        }

        public long range() {
            return VkBufferViewCreateInfo.nrange(this.address());
        }

        public Buffer sType(int value) {
            VkBufferViewCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkBufferViewCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkBufferViewCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer buffer(long value) {
            VkBufferViewCreateInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer format(int value) {
            VkBufferViewCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(long value) {
            VkBufferViewCreateInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer range(long value) {
            VkBufferViewCreateInfo.nrange(this.address(), value);
            return this;
        }
    }
}

