/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorBufferInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int RANGE;

    VkDescriptorBufferInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDescriptorBufferInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDescriptorBufferInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long buffer() {
        return VkDescriptorBufferInfo.nbuffer(this.address());
    }

    public long offset() {
        return VkDescriptorBufferInfo.noffset(this.address());
    }

    public long range() {
        return VkDescriptorBufferInfo.nrange(this.address());
    }

    public VkDescriptorBufferInfo buffer(long value) {
        VkDescriptorBufferInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo offset(long value) {
        VkDescriptorBufferInfo.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo range(long value) {
        VkDescriptorBufferInfo.nrange(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo set(long buffer, long offset, long range) {
        this.buffer(buffer);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public VkDescriptorBufferInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkDescriptorBufferInfo set(VkDescriptorBufferInfo src) {
        return this.nset(src.address());
    }

    public static VkDescriptorBufferInfo malloc() {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDescriptorBufferInfo calloc() {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDescriptorBufferInfo create() {
        return new VkDescriptorBufferInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDescriptorBufferInfo create(long address) {
        return address == 0L ? null : new VkDescriptorBufferInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDescriptorBufferInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDescriptorBufferInfo mallocStack() {
        return VkDescriptorBufferInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorBufferInfo callocStack() {
        return VkDescriptorBufferInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorBufferInfo mallocStack(MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorBufferInfo callocStack(MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorBufferInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorBufferInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorBufferInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RANGE);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorBufferInfo.__struct(VkDescriptorBufferInfo.__member(8), VkDescriptorBufferInfo.__member(8), VkDescriptorBufferInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        RANGE = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkDescriptorBufferInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDescriptorBufferInfo newInstance(long address) {
            return new VkDescriptorBufferInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long buffer() {
            return VkDescriptorBufferInfo.nbuffer(this.address());
        }

        public long offset() {
            return VkDescriptorBufferInfo.noffset(this.address());
        }

        public long range() {
            return VkDescriptorBufferInfo.nrange(this.address());
        }

        public Buffer buffer(long value) {
            VkDescriptorBufferInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(long value) {
            VkDescriptorBufferInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer range(long value) {
            VkDescriptorBufferInfo.nrange(this.address(), value);
            return this;
        }
    }
}

