/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkImageFormatProperties
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXEXTENT;
    public static final int MAXMIPLEVELS;
    public static final int MAXARRAYLAYERS;
    public static final int SAMPLECOUNTS;
    public static final int MAXRESOURCESIZE;

    VkImageFormatProperties(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkImageFormatProperties(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkImageFormatProperties.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkExtent3D maxExtent() {
        return VkImageFormatProperties.nmaxExtent(this.address());
    }

    public int maxMipLevels() {
        return VkImageFormatProperties.nmaxMipLevels(this.address());
    }

    public int maxArrayLayers() {
        return VkImageFormatProperties.nmaxArrayLayers(this.address());
    }

    public int sampleCounts() {
        return VkImageFormatProperties.nsampleCounts(this.address());
    }

    public long maxResourceSize() {
        return VkImageFormatProperties.nmaxResourceSize(this.address());
    }

    public static VkImageFormatProperties malloc() {
        return VkImageFormatProperties.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkImageFormatProperties calloc() {
        return VkImageFormatProperties.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkImageFormatProperties create() {
        return new VkImageFormatProperties(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkImageFormatProperties create(long address) {
        return address == 0L ? null : new VkImageFormatProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkImageFormatProperties.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageFormatProperties.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkImageFormatProperties mallocStack() {
        return VkImageFormatProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatProperties callocStack() {
        return VkImageFormatProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkImageFormatProperties mallocStack(MemoryStack stack) {
        return VkImageFormatProperties.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageFormatProperties callocStack(MemoryStack stack) {
        return VkImageFormatProperties.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageFormatProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageFormatProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageFormatProperties.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageFormatProperties.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkExtent3D nmaxExtent(long struct) {
        return VkExtent3D.create(struct + (long)MAXEXTENT);
    }

    public static int nmaxMipLevels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXMIPLEVELS);
    }

    public static int nmaxArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXARRAYLAYERS);
    }

    public static int nsampleCounts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLECOUNTS);
    }

    public static long nmaxResourceSize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MAXRESOURCESIZE);
    }

    static {
        Struct.Layout layout = VkImageFormatProperties.__struct(VkImageFormatProperties.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF), VkImageFormatProperties.__member(4), VkImageFormatProperties.__member(4), VkImageFormatProperties.__member(4), VkImageFormatProperties.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXEXTENT = layout.offsetof(0);
        MAXMIPLEVELS = layout.offsetof(1);
        MAXARRAYLAYERS = layout.offsetof(2);
        SAMPLECOUNTS = layout.offsetof(3);
        MAXRESOURCESIZE = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<VkImageFormatProperties, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkImageFormatProperties newInstance(long address) {
            return new VkImageFormatProperties(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public VkExtent3D maxExtent() {
            return VkImageFormatProperties.nmaxExtent(this.address());
        }

        public int maxMipLevels() {
            return VkImageFormatProperties.nmaxMipLevels(this.address());
        }

        public int maxArrayLayers() {
            return VkImageFormatProperties.nmaxArrayLayers(this.address());
        }

        public int sampleCounts() {
            return VkImageFormatProperties.nsampleCounts(this.address());
        }

        public long maxResourceSize() {
            return VkImageFormatProperties.nmaxResourceSize(this.address());
        }
    }
}

