/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryType
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROPERTYFLAGS;
    public static final int HEAPINDEX;

    VkMemoryType(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryType(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryType.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int propertyFlags() {
        return VkMemoryType.npropertyFlags(this.address());
    }

    public int heapIndex() {
        return VkMemoryType.nheapIndex(this.address());
    }

    public static VkMemoryType malloc() {
        return VkMemoryType.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMemoryType calloc() {
        return VkMemoryType.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMemoryType create() {
        return new VkMemoryType(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryType create(long address) {
        return address == 0L ? null : new VkMemoryType(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryType.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryType.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMemoryType mallocStack() {
        return VkMemoryType.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryType callocStack() {
        return VkMemoryType.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryType mallocStack(MemoryStack stack) {
        return VkMemoryType.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryType callocStack(MemoryStack stack) {
        return VkMemoryType.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryType.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryType.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryType.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryType.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npropertyFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROPERTYFLAGS);
    }

    public static int nheapIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEAPINDEX);
    }

    static {
        Struct.Layout layout = VkMemoryType.__struct(VkMemoryType.__member(4), VkMemoryType.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROPERTYFLAGS = layout.offsetof(0);
        HEAPINDEX = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkMemoryType, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryType newInstance(long address) {
            return new VkMemoryType(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int propertyFlags() {
            return VkMemoryType.npropertyFlags(this.address());
        }

        public int heapIndex() {
            return VkMemoryType.nheapIndex(this.address());
        }
    }
}

