/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkXlibSurfaceCreateInfoKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DPY;
    public static final int WINDOW;

    VkXlibSurfaceCreateInfoKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkXlibSurfaceCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkXlibSurfaceCreateInfoKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkXlibSurfaceCreateInfoKHR.nsType(this.address());
    }

    public long pNext() {
        return VkXlibSurfaceCreateInfoKHR.npNext(this.address());
    }

    public int flags() {
        return VkXlibSurfaceCreateInfoKHR.nflags(this.address());
    }

    public long dpy() {
        return VkXlibSurfaceCreateInfoKHR.ndpy(this.address());
    }

    public long window() {
        return VkXlibSurfaceCreateInfoKHR.nwindow(this.address());
    }

    public VkXlibSurfaceCreateInfoKHR sType(int value) {
        VkXlibSurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR pNext(long value) {
        VkXlibSurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR flags(int value) {
        VkXlibSurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR dpy(long value) {
        VkXlibSurfaceCreateInfoKHR.ndpy(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR window(long value) {
        VkXlibSurfaceCreateInfoKHR.nwindow(this.address(), value);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR set(int sType, long pNext, int flags, long dpy, long window) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dpy(dpy);
        this.window(window);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkXlibSurfaceCreateInfoKHR set(VkXlibSurfaceCreateInfoKHR src) {
        return this.nset(src.address());
    }

    public static VkXlibSurfaceCreateInfoKHR malloc() {
        return VkXlibSurfaceCreateInfoKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR calloc() {
        return VkXlibSurfaceCreateInfoKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR create() {
        return new VkXlibSurfaceCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR create(long address) {
        return address == 0L ? null : new VkXlibSurfaceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkXlibSurfaceCreateInfoKHR mallocStack() {
        return VkXlibSurfaceCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkXlibSurfaceCreateInfoKHR callocStack() {
        return VkXlibSurfaceCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkXlibSurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkXlibSurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkXlibSurfaceCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkXlibSurfaceCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long ndpy(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DPY);
    }

    public static long nwindow(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WINDOW);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndpy(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DPY, Checks.checkPointer(value));
    }

    public static void nwindow(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WINDOW, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)DPY));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkXlibSurfaceCreateInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkXlibSurfaceCreateInfoKHR.__struct(VkXlibSurfaceCreateInfoKHR.__member(4), VkXlibSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkXlibSurfaceCreateInfoKHR.__member(4), VkXlibSurfaceCreateInfoKHR.__member(POINTER_SIZE), VkXlibSurfaceCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DPY = layout.offsetof(3);
        WINDOW = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<VkXlibSurfaceCreateInfoKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkXlibSurfaceCreateInfoKHR newInstance(long address) {
            return new VkXlibSurfaceCreateInfoKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkXlibSurfaceCreateInfoKHR.nsType(this.address());
        }

        public long pNext() {
            return VkXlibSurfaceCreateInfoKHR.npNext(this.address());
        }

        public int flags() {
            return VkXlibSurfaceCreateInfoKHR.nflags(this.address());
        }

        public long dpy() {
            return VkXlibSurfaceCreateInfoKHR.ndpy(this.address());
        }

        public long window() {
            return VkXlibSurfaceCreateInfoKHR.nwindow(this.address());
        }

        public Buffer sType(int value) {
            VkXlibSurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkXlibSurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkXlibSurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer dpy(long value) {
            VkXlibSurfaceCreateInfoKHR.ndpy(this.address(), value);
            return this;
        }

        public Buffer window(long value) {
            VkXlibSurfaceCreateInfoKHR.nwindow(this.address(), value);
            return this;
        }
    }
}

