/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.controller.api.Application;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class Gva {
    private final OscAddressSpace w2Z;
    private final ControllerHost BOK;
    private final Transport HaN;
    private final OscConnection rLM;
    private final MasterTrack bsM;
    private final TrackBank KyJ;
    private final TrackBank UN3;
    private final Application JEB;
    private final Clip zxv;
    private final Clip Bh1;
    private final CursorTrack r2;

    public Gva(ControllerHost controllerHost) {
        this.BOK = controllerHost;
        this.JEB = controllerHost.createApplication();
        this.HaN = controllerHost.createTransport();
        this.HaN.tempo().markInterested();
        this.HaN.isMetronomeEnabled().markInterested();
        this.HaN.isMetronomeEnabled().addValueObserver(this::w2Z);
        this.HaN.isPlaying().markInterested();
        this.HaN.isPlaying().addValueObserver(this::BOK);
        this.HaN.isArrangerRecordEnabled().markInterested();
        this.HaN.isArrangerRecordEnabled().addValueObserver(this::HaN);
        this.HaN.isClipLauncherOverdubEnabled().markInterested();
        this.HaN.isClipLauncherOverdubEnabled().addValueObserver(this::rLM);
        this.HaN.isClipLauncherAutomationWriteEnabled().markInterested();
        this.HaN.isClipLauncherAutomationWriteEnabled().addValueObserver(this::bsM);
        this.HaN.isArrangerLoopEnabled().markInterested();
        this.HaN.isArrangerLoopEnabled().addValueObserver(this::KyJ);
        this.r2 = this.BOK.createCursorTrack(0, 0);
        this.r2.position().addValueObserver(n2 -> this.bsM());
        this.r2.trackType().markInterested();
        this.bsM = this.BOK.createMasterTrack(100);
        this.KyJ = this.BOK.createMainTrackBank(100, 20, 100);
        this.UN3 = this.BOK.createEffectTrackBank(20, 100);
        this.KyJ.itemCount().markInterested();
        this.KyJ.sceneBank().itemCount().markInterested();
        this.UN3.itemCount().markInterested();
        for (int i2 = 0; i2 < this.KyJ.getSizeOfBank(); ++i2) {
            int n3 = i2;
            Track track = (Track)this.KyJ.getItemAt(i2);
            track.trackType().markInterested();
            track.mute().addValueObserver(bl2 -> this.w2Z(track, n3));
            track.arm().addValueObserver(bl2 -> this.BOK(track, n3));
            track.solo().addValueObserver(bl2 -> this.HaN(track, n3));
            track.volume().value().addValueObserver(d2 -> this.rLM(track, n3));
            track.pan().value().addValueObserver(d2 -> this.bsM(track, n3));
        }
        this.zxv = this.BOK.createArrangerCursorClip(1, 1);
        this.Bh1 = this.BOK.createLauncherCursorClip(1, 1);
        OscModule oscModule = this.BOK.getOscModule();
        this.w2Z = oscModule.createAddressSpace();
        this.w2Z.registerObjectMethods("/dawctrl", this);
        this.rLM = oscModule.connectToUdpServer("localhost", 7577, this.w2Z);
        oscModule.createUdpServer(7578, this.w2Z);
    }

    public void w2Z() {
        this.UN3();
    }

    private int w2Z(Track track) {
        String string;
        switch (string = track.trackType().get()) {
            case "Group": {
                return 3;
            }
            case "Instrument": {
                return 2;
            }
            case "Audio": {
                return 1;
            }
            case "Hybrid": {
                return 0;
            }
            case "Effect": {
                return 4;
            }
            case "Master": {
                return 5;
            }
        }
        return 0;
    }

    private void w2Z(String string, Object ... objectArray) {
        try {
            this.rLM.sendMessage(string, objectArray);
        }
        catch (IOException iOException) {
            this.BOK.println("Error while sending OSC message to: " + string + "\n" + iOException.getMessage() + "\n");
        }
    }

    private void BOK() {
        this.rLM();
        this.bsM();
        this.KyJ();
        this.rLM(this.bsM, 0);
        this.bsM(this.bsM, 0);
        this.bsM(this.HaN.isClipLauncherAutomationWriteEnabled().get());
        this.KyJ(this.HaN.isArrangerLoopEnabled().get());
        this.w2Z(this.HaN.isMetronomeEnabled().get());
    }

    private void HaN() {
        this.w2Z("/dawctrl/pong", new Object[0]);
    }

    private void w2Z(boolean bl2) {
        this.w2Z("/dawctrl/metronome", bl2 ? 1 : 0);
    }

    private void BOK(boolean bl2) {
        this.w2Z("/dawctrl/play", bl2 ? 1 : 0);
    }

    private void HaN(boolean bl2) {
        this.w2Z("/dawctrl/record", bl2 ? 1 : 0);
    }

    private void rLM(boolean bl2) {
        this.w2Z("/dawctrl/session_record", bl2 ? 1 : 0);
    }

    private void bsM(boolean bl2) {
        this.w2Z("/dawctrl/session_automation_record", bl2 ? 1 : 0);
    }

    private void KyJ(boolean bl2) {
        this.w2Z("/dawctrl/loop", bl2 ? 1 : 0);
    }

    private void rLM() {
        this.w2Z("/dawctrl/size", this.KyJ.itemCount().get(), this.KyJ.sceneBank().itemCount().get(), this.UN3.itemCount().get());
    }

    private void bsM() {
        int n2 = this.r2.position().get();
        int n3 = this.w2Z(this.r2);
        this.w2Z("/dawctrl/track", n3, n2, "");
    }

    private void KyJ() {
        this.w2Z("/dawctrl/scene", 0, "");
    }

    private void w2Z(Track track, int n2) {
        int n3 = this.w2Z(track);
        boolean bl2 = track.mute().get();
        this.w2Z("/dawctrl/track/mute", n3, n2, bl2 ? 1 : 0);
    }

    private void BOK(Track track, int n2) {
        int n3 = this.w2Z(track);
        boolean bl2 = track.arm().get();
        this.w2Z("/dawctrl/track/arm", n3, n2, bl2 ? 1 : 0);
    }

    private void HaN(Track track, int n2) {
        int n3 = this.w2Z(track);
        boolean bl2 = track.solo().get();
        this.w2Z("/dawctrl/track/solo", n3, n2, bl2 ? 1 : 0);
    }

    private void rLM(Track track, int n2) {
        int n3 = this.w2Z(track);
        float f2 = (float)track.volume().get();
        this.w2Z("/dawctrl/track/solo", n3, n2, Float.valueOf(f2));
    }

    private void bsM(Track track, int n2) {
        int n3 = this.w2Z(track);
        float f2 = (float)track.pan().get();
        this.w2Z("/dawctrl/track/pan", n3, n2, Float.valueOf(f2));
    }

    private void UN3() {
        this.w2Z("/dawctrl/shutdown", new Object[0]);
    }

    @OscMethod(address="/init")
    public void handleInit() {
        this.BOK();
    }

    @OscMethod(address="/ping")
    public void handlePing() {
        this.HaN();
    }

    @OscMethod(address="/stop/all_clips")
    public void handleStopAllClips() {
        this.bsM.stop();
    }

    @OscMethod(address="/stop/track")
    public void handleStopTrack(int n2) {
        this.KyJ.getChannel(n2).stop();
    }

    @OscMethod(address="/play/scene")
    public void handlePlayScene(int n2) {
        ((ClipLauncherSlot)this.bsM.clipLauncherSlotBank().getItemAt(n2)).launch();
    }

    @OscMethod(address="/play/clip")
    public void handlePlayClip(int n2, int n3) {
        ((ClipLauncherSlot)this.KyJ.getChannel(n2).clipLauncherSlotBank().getItemAt(n3)).launch();
    }

    @OscMethod(address="/stop/clip")
    public void handleStopClip(int n2, int n3) {
        this.KyJ.getChannel(n2).stop();
    }

    @OscMethod(address="/undo")
    public void handleUndo() {
        this.JEB.undo();
    }

    @OscMethod(address="/redo")
    public void handleRedo() {
        this.JEB.redo();
    }

    @OscMethod(address="/loop")
    public void handleLoop(int n2) {
        this.HaN.isArrangerLoopEnabled().set(n2 != 0);
    }

    @OscMethod(address="/play")
    public void handlePlay() {
        this.HaN.play();
    }

    @OscMethod(address="/record")
    public void handleRecord(int n2) {
        this.HaN.isArrangerRecordEnabled().set(n2 != 0);
    }

    @OscMethod(address="/session_record")
    public void handleSessionRecord(int n2) {
        this.HaN.isClipLauncherOverdubEnabled().set(n2 != 0);
        this.HaN.isClipLauncherAutomationWriteEnabled().set(n2 != 0);
    }

    @OscMethod(address="/metronome")
    public void handleMetronome(int n2) {
        this.HaN.isMetronomeEnabled().set(n2 != 0);
    }

    @OscMethod(address="/stop")
    public void handleStop() {
        this.HaN.stop();
    }

    @OscMethod(address="/scrub")
    public void handleScrub(float f2) {
    }

    @OscMethod(address="/automation")
    public void handleAutomation(int n2) {
        this.HaN.isArrangerAutomationWriteEnabled().set(n2 != 0);
    }

    private Track w2Z(int n2, int n3) {
        switch (n2) {
            case 0: {
                return this.KyJ.getChannel(n3);
            }
            case 1: {
                return this.KyJ.getChannel(n3);
            }
            case 2: {
                return this.KyJ.getChannel(n3);
            }
            case 3: {
                return this.KyJ.getChannel(n3);
            }
            case 4: {
                return this.UN3.getChannel(n3);
            }
            case 5: {
                return this.bsM;
            }
            case 6: {
                return this.KyJ.getChannel(n3);
            }
        }
        this.BOK.println("Received invalid track type: " + n2);
        return null;
    }

    @OscMethod(address="/track/arm")
    public void handleTrackArm(int n2, int n3, int n4) {
        this.w2Z(n2, n3).getArm().set(n4 != 0);
    }

    @OscMethod(address="/track/mute")
    public void handleTrackMute(int n2, int n3, int n4) {
        this.w2Z(n2, n3).getMute().set(n4 != 0);
    }

    @OscMethod(address="/track/solo")
    public void handleTrackSolo(int n2, int n3, int n4) {
        this.w2Z(n2, n3).getSolo().set(n4 != 0);
    }

    @OscMethod(address="/track/volume")
    public void handleTrackVolume(int n2, int n3, float f2) {
        this.w2Z(n2, n3).getVolume().set(f2);
    }

    @OscMethod(address="/track/pan")
    public void handleTrackPan(int n2, int n3, float f2) {
        this.w2Z(n2, n3).getPan().set(f2);
    }

    @OscMethod(address="/tap_tempo")
    public void handleTapTempo() {
        this.HaN.tapTempo();
    }

    @OscMethod(address="/clip/quantize")
    public void handleClipQuantize() {
        this.zxv.quantize(1.0);
        this.Bh1.quantize(1.0);
    }

    @OscMethod(address="/scene/view")
    public void handleSceneView() {
    }

    @OscMethod(address="/track/view")
    public void handleTrackView() {
    }

    @OscMethod(address="/midi_arm_exclusive")
    public void handleMidiArmExclusive() {
        this.r2.getArm().set(true);
    }

    @OscMethod(address="/track/info")
    public void handleTrackInfo() {
    }
}

