/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.util.midi.ShortMidiMessage;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RemoteControl;
import com.bitwig.extension.controller.api.Transport;
import com.bitwig.extension.controller.api.UserControlBank;

class THL
extends ControllerExtension {
    private Transport w2Z;
    private CursorRemoteControlsPage BOK;
    private UserControlBank HaN;

    protected THL(nhz nhz2, ControllerHost controllerHost) {
        super(nhz2, controllerHost);
    }

    @Override
    public void init() {
        int n2;
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        MidiIn midiIn = controllerHost.getMidiInPort(0);
        midiIn.setMidiCallback(this::w2Z);
        midiIn.setSysexCallback(this::w2Z);
        NoteInput noteInput = midiIn.createNoteInput("All Channels", "??????");
        noteInput.setShouldConsumeEvents(false);
        for (int i2 = 0; i2 < 16; ++i2) {
            midiIn.createNoteInput("Channel " + (i2 + 1), "?" + Integer.toHexString(i2) + "????");
        }
        this.w2Z = controllerHost.createTransport();
        CursorTrack cursorTrack = controllerHost.createCursorTrack(3, 0);
        PinnableCursorDevice pinnableCursorDevice = cursorTrack.createCursorDevice();
        this.BOK = pinnableCursorDevice.createCursorRemoteControlsPage(8);
        for (n2 = 0; n2 < 8; ++n2) {
            RemoteControl remoteControl = this.BOK.getParameter(n2);
            remoteControl.setIndication(true);
            remoteControl.setLabel("P" + (n2 + 1));
        }
        this.HaN = controllerHost.createUserControls(111);
        for (n2 = 1; n2 < 119; ++n2) {
            if (THL.w2Z(n2)) continue;
            int n3 = THL.BOK(n2);
            this.HaN.getControl(n3).setLabel("CC" + n2);
        }
    }

    private static boolean w2Z(int n2) {
        return n2 >= 20 && n2 <= 27;
    }

    private static int BOK(int n2) {
        if (n2 > 27) {
            return n2 - 1 - 8;
        }
        return n2 - 1;
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void w2Z(ShortMidiMessage shortMidiMessage) {
        if (shortMidiMessage.isControlChange()) {
            int n2 = shortMidiMessage.getData1();
            if (THL.w2Z(n2)) {
                int n3 = n2 - 20;
                this.BOK.getParameter(n3).value().set(shortMidiMessage.getData2(), 128);
            } else if (n2 >= 1 && n2 <= 119) {
                int n4 = THL.BOK(n2);
                this.HaN.getControl(n4).value().set(shortMidiMessage.getData2(), 128);
            }
        }
    }

    private void w2Z(String string) {
        switch (string) {
            case "f07f7f0605f7": {
                this.w2Z.rewind();
                break;
            }
            case "f07f7f0604f7": {
                this.w2Z.fastForward();
                break;
            }
            case "f07f7f0601f7": {
                this.w2Z.stop();
                break;
            }
            case "f07f7f0602f7": {
                this.w2Z.play();
                break;
            }
            case "f07f7f0606f7": {
                this.w2Z.record();
            }
        }
    }
}

