/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.file_notification.linux;

import com.bitwig.base.file_notification.FileSystemWatcher;
import com.bitwig.base.file_notification.aOa;
import com.bitwig.base.file_notification.linux.pdu;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class LinuxFileSystemWatcher
extends FileSystemWatcher {
    private static final Executor w2Z = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private long BOK;
    private Semaphore HaN;

    protected LinuxFileSystemWatcher(File file, int n2, boolean bl2, aOa aOa2) {
        super(file, n2, bl2, aOa2);
        this.BOK = this.create(file.getAbsolutePath(), n2, bl2);
        if (this.BOK == 0L) {
            throw new IOException("Could not register watch for directory " + String.valueOf(file));
        }
        if (bl2) {
            this.HaN = new Semaphore(0);
            w2Z.execute(new pdu(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        LinuxFileSystemWatcher linuxFileSystemWatcher = this;
        synchronized (linuxFileSystemWatcher) {
            if (this.BOK != 0L) {
                if (this.isRecursive()) {
                    LinuxFileSystemWatcher.stopAddingSubHierarchyWatchers(this.BOK);
                    try {
                        this.HaN.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LinuxFileSystemWatcher.destroy(this.BOK);
                this.BOK = 0L;
            }
        }
    }

    private native long create(String var1, int var2, boolean var3);

    private static native void addSubHierarchyWatchers(long var0);

    private static native void stopAddingSubHierarchyWatchers(long var0);

    private static native void destroy(long var0);

    private void fileCreated(String string) {
        this.mListener.w2Z(this, string);
    }

    private void fileModified(String string) {
        this.mListener.HaN(this, string);
    }

    private void fileDeleted(String string) {
        this.mListener.BOK(this, string);
    }
}

