/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.serial.file;

import com.bitwig.base.io.kln;
import com.bitwig.base.serial.SerializationException;
import com.bitwig.base.serial.file.InvalidFileHeaderException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OCP {
    private final int BOK;
    private final int HaN;
    private final int rLM;
    private final int bsM;
    private int KyJ = 0;
    private int UN3;
    private long JEB;

    public static OCP w2Z(File file) {
        assert (bSE.BOK(file != null));
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            OCP oCP = OCP.w2Z(bufferedInputStream);
            return oCP;
        }
    }

    public static OCP w2Z(qyU qyU2) {
        assert (bSE.BOK(qyU2 != null));
        try (InputStream inputStream = qyU2.w2Z();){
            OCP oCP = OCP.w2Z(inputStream);
            return oCP;
        }
    }

    public static OCP w2Z(InputStream inputStream) {
        try {
            long l2;
            int n2;
            int n3 = kln.rLM(inputStream);
            int n4 = kln.r2(inputStream);
            if (n4 < 0) {
                throw new InvalidFileHeaderException("Negative file format version");
            }
            int n5 = kln.r2(inputStream);
            if (n5 < 0) {
                throw new InvalidFileHeaderException("Negative serialization format id");
            }
            int n6 = kln.r2(inputStream);
            if (n6 < 0) {
                throw new InvalidFileHeaderException("Negative document version number");
            }
            int n7 = -1;
            if (n4 >= 1 && (n7 = kln.w2Z(inputStream, 8)) < (n2 = OCP.BOK(n4))) {
                throw new InvalidFileHeaderException("Invalid object offset");
            }
            if (n4 == 2) {
                n2 = kln.r2(inputStream);
                long l3 = kln.BOK(inputStream, 16);
            }
            if ((l2 = kln.BOK(inputStream, 16)) < 0L) {
                throw new InvalidFileHeaderException("Negative resources offset");
            }
            int n8 = n4 >= 3 ? kln.w2Z(inputStream, 2) : 0;
            return new OCP(n3, n4, n5, n6, n7, l2, n8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFileHeaderException(numberFormatException.getLocalizedMessage());
        }
    }

    public OCP(int n2, int n3, int n4, int n5, int n6, long l2, int n7) {
        assert (bSE.BOK(n3 <= 3));
        assert (bSE.BOK(n3 < 3 ? n7 == 0 : true));
        this.BOK = n2;
        this.HaN = n3;
        this.rLM = n4;
        this.bsM = n5;
        this.UN3 = n6;
        this.JEB = l2;
        this.KyJ = n7;
    }

    public int w2Z() {
        return this.BOK;
    }

    public int BOK() {
        return this.HaN;
    }

    public int HaN() {
        return this.rLM;
    }

    public int rLM() {
        return this.bsM;
    }

    public boolean bsM() {
        return this.JEB != 0L;
    }

    public int KyJ() {
        if (this.UN3 == -1) {
            throw new InvalidFileHeaderException("Object offset not supported");
        }
        return this.UN3;
    }

    void w2Z(int n2) {
        try {
            assert (bSE.BOK(n2 >= this.JEB()));
        }
        catch (SerializationException serializationException) {
            throw new IllegalStateException(serializationException);
        }
        this.UN3 = n2;
    }

    public long UN3() {
        assert (bSE.BOK(this.bsM()));
        return this.JEB;
    }

    void w2Z(long l2) {
        this.JEB = l2;
    }

    public void w2Z(OutputStream outputStream) {
        assert (bSE.BOK(outputStream != null));
        if (this.HaN > 3) {
            throw new IOException("Cannot write file format version " + this.HaN);
        }
        kln.w2Z(outputStream, this.BOK);
        kln.BOK(outputStream, this.HaN);
        kln.BOK(outputStream, this.rLM);
        kln.BOK(outputStream, this.bsM);
        if (this.HaN >= 1) {
            try {
                assert (bSE.BOK(this.UN3 >= this.JEB()));
            }
            catch (SerializationException serializationException) {
                throw new IllegalStateException(serializationException);
            }
            kln.w2Z(outputStream, this.UN3, 8);
        }
        if (this.HaN == 2) {
            kln.BOK(outputStream, 0);
            kln.w2Z(outputStream, 0L, 16);
        }
        kln.w2Z(outputStream, this.JEB, 16);
        if (this.HaN >= 3) {
            kln.w2Z(outputStream, this.KyJ, 2);
        }
    }

    public int JEB() {
        return OCP.BOK(this.HaN);
    }

    public boolean zxv() {
        boolean bl2;
        boolean bl3 = bl2 = (this.KyJ & 1) == 0;
        assert (bSE.BOK(!bl2 ? this.HaN >= 3 : true));
        return bl2;
    }

    public void w2Z(boolean bl2) {
        assert (bSE.BOK(this.HaN < 3 ? bl2 : true));
        this.KyJ = bl2 ? (this.KyJ &= 0xFFFFFFFE) : (this.KyJ |= 1);
        assert (bSE.BOK(this.zxv() == bl2));
    }

    public static int BOK(int n2) {
        if (n2 == 0) {
            return 32;
        }
        if (n2 == 1) {
            return 40;
        }
        if (n2 == 2) {
            return 60;
        }
        if (n2 == 3) {
            return 42;
        }
        throw new InvalidFileHeaderException("Unsupported file format version " + n2);
    }

    int Bh1() {
        if (this.HaN == 0) {
            return 16;
        }
        if (this.HaN == 1) {
            return 24;
        }
        if (this.HaN == 2) {
            return 44;
        }
        if (this.HaN == 3) {
            return 24;
        }
        throw new InvalidFileHeaderException("Unsupported file format version " + this.HaN);
    }
}

