/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extension.api;

public class Color {
    private final double mRed;
    private final double mGreen;
    private final double mBlue;
    private final double mAlpha;

    private Color(double d2, double d3, double d4, double d5) {
        this.mRed = d2;
        this.mGreen = d3;
        this.mBlue = d4;
        this.mAlpha = d5;
    }

    public static Color fromRGB(double d2, double d3, double d4) {
        return new Color(d2, d3, d4, 1.0);
    }

    public static Color fromRGBA(double d2, double d3, double d4, double d5) {
        return new Color(d2, d3, d4, d5);
    }

    public static Color fromRGB255(int n2, int n3, int n4) {
        return new Color((double)n2 / 255.0, (double)n3 / 255.0, (double)n4 / 255.0, 1.0);
    }

    public static Color fromRGBA255(int n2, int n3, int n4, int n5) {
        return new Color((double)n2 / 255.0, (double)n3 / 255.0, (double)n4 / 255.0, (double)n5 / 255.0);
    }

    public static Color fromHex(String string) {
        int n2;
        int n3;
        if (string.isEmpty()) {
            return Color.nullColor();
        }
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        for (n3 = 0; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            if (48 <= n2 && n2 <= 57 || 97 <= n2 && n2 <= 102 || 65 <= n2 && n2 <= 70) continue;
            return Color.nullColor();
        }
        switch (string.length()) {
            case 3: {
                n3 = Integer.parseInt(string.substring(0, 1), 16);
                n2 = Integer.parseInt(string.substring(1, 2), 16);
                int n4 = Integer.parseInt(string.substring(2, 3), 16);
                return Color.fromRGB((double)n3 / 15.0, (double)n2 / 15.0, (double)n4 / 15.0);
            }
            case 4: {
                n3 = Integer.parseInt(string.substring(0, 1), 16);
                n2 = Integer.parseInt(string.substring(1, 2), 16);
                int n5 = Integer.parseInt(string.substring(2, 3), 16);
                int n6 = Integer.parseInt(string.substring(2, 3), 16);
                return Color.fromRGBA((double)n3 / 15.0, (double)n2 / 15.0, (double)n5 / 15.0, (double)n6 / 15.0);
            }
            case 6: {
                n3 = Integer.parseInt(string.substring(0, 2), 16);
                n2 = Integer.parseInt(string.substring(2, 4), 16);
                int n7 = Integer.parseInt(string.substring(4, 6), 16);
                return Color.fromRGB255(n3, n2, n7);
            }
            case 8: {
                n3 = Integer.parseInt(string.substring(0, 2), 16);
                n2 = Integer.parseInt(string.substring(2, 4), 16);
                int n8 = Integer.parseInt(string.substring(4, 6), 16);
                int n9 = Integer.parseInt(string.substring(6, 8), 16);
                return Color.fromRGBA255(n3, n2, n8, n9);
            }
        }
        return Color.nullColor();
    }

    public static Color mix(Color color, Color color2, double d2) {
        double d3 = d2;
        double d4 = 1.0 - d2;
        return new Color(color.getRed() * d3 + color2.getRed() * d4, color.getGreen() * d3 + color2.getGreen() * d4, color.getBlue() * d3 + color2.getBlue() * d4, color.getAlpha() * d3 + color2.getAlpha() * d4);
    }

    public String toHex() {
        int n2 = this.getRed255();
        int n3 = this.getGreen255();
        int n4 = this.getBlue255();
        int n5 = this.getAlpha255();
        StringBuilder stringBuilder = new StringBuilder(9);
        stringBuilder.append("#");
        this.addHex2Number(stringBuilder, n2);
        this.addHex2Number(stringBuilder, n3);
        this.addHex2Number(stringBuilder, n4);
        if (n5 != 255) {
            this.addHex2Number(stringBuilder, n5);
        }
        return stringBuilder.toString();
    }

    private void addHex2Number(StringBuilder stringBuilder, int n2) {
        String string = Integer.toHexString(n2 & 0xFF);
        if (string.length() == 1) {
            stringBuilder.append(0);
        }
        stringBuilder.append(string);
    }

    public static Color nullColor() {
        return Color.fromRGBA(0.0, 0.0, 0.0, 0.0);
    }

    public static Color blackColor() {
        return Color.fromRGBA(0.0, 0.0, 0.0, 1.0);
    }

    public static Color whiteColor() {
        return Color.fromRGBA(1.0, 1.0, 1.0, 1.0);
    }

    public double getRed() {
        return this.mRed;
    }

    public double getGreen() {
        return this.mGreen;
    }

    public double getBlue() {
        return this.mBlue;
    }

    public double getAlpha() {
        return this.mAlpha;
    }

    public int getRed255() {
        return (int)(this.mRed * 255.0);
    }

    public int getGreen255() {
        return (int)(this.mGreen * 255.0);
    }

    public int getBlue255() {
        return (int)(this.mBlue * 255.0);
    }

    public int getAlpha255() {
        return (int)(this.mAlpha * 255.0);
    }

    public void toHSV(double[] dArray) {
        double d2;
        assert (this.mRed >= 0.0 && this.mRed <= 1.0);
        assert (this.mGreen >= 0.0 && this.mGreen <= 1.0);
        assert (this.mBlue >= 0.0 && this.mBlue <= 1.0);
        assert (dArray != null);
        assert (dArray.length == 3);
        double d3 = Math.min(Math.min(this.mRed, this.mGreen), this.mBlue);
        double d4 = d2 = Math.max(Math.max(this.mRed, this.mGreen), this.mBlue);
        double d5 = d2 - d3;
        if (d2 == 0.0) {
            double d6 = 0.0;
            double d7 = 0.0;
            assert (d7 >= 0.0 && d7 <= 360.0);
            assert (d6 >= 0.0 && d6 <= 1.0);
            assert (d4 >= 0.0 && d4 <= 1.0);
            dArray[0] = d7;
            dArray[1] = d6;
            dArray[2] = d4;
            return;
        }
        double d8 = d5 / d2;
        double d9 = d5 == 0.0 ? 0.0 : (this.mRed == d2 ? (this.mGreen - this.mBlue) / d5 : (this.mGreen == d2 ? 2.0 + (this.mBlue - this.mRed) / d5 : 4.0 + (this.mRed - this.mGreen) / d5));
        d9 *= 60.0;
        if (d9 < 0.0) {
            d9 += 360.0;
        }
        assert (d9 >= 0.0 && d9 <= 360.0);
        assert (d8 >= 0.0 && d8 <= 1.0);
        assert (d4 >= 0.0 && d4 <= 1.0);
        dArray[0] = d9;
        dArray[1] = d8;
        dArray[2] = d4;
    }
}

