/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements;

import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extension.api.project.timeline.AudioClipContent;
import com.bitwig.extension.api.project.timeline.AudioNote;
import com.bitwig.extension.api.project.timeline.AudioNoteTimeline;
import com.bitwig.extension.api.project.timeline.TransientRate;
import com.bitwig.extension.api.project.timeline.WarpMarkers;
import com.bitwig.extension.api.project.timeline.WarpMode;
import com.bitwig.extension.api.project.timeline.WarpTailMode;
import com.bitwig.extensions.importer.als.elements.Clip;
import com.bitwig.extensions.importer.als.elements.MainSequencer;
import com.bitwig.extensions.importer.als.elements.Modulation;
import com.bitwig.extensions.importer.als.elements.SampleRef;
import com.bitwig.extensions.importer.als.elements.pdu;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class AudioClip
extends Clip {
    private List w2Z = new ArrayList();
    private double BOK;
    private double HaN;
    private double rLM;
    private double bsM;
    private double KyJ;
    private boolean UN3;
    private int zxv;
    private int Bh1;
    private int r2;
    private double cFc;
    private double OhK;
    private double Gox;
    private List gFf = new ArrayList();
    private SampleRef GvW;
    private final MainSequencer wFl;
    private AudioNote X3Z;
    private boolean gU;
    private int FMt;

    public AudioClip(ejc ejc2, com.bitwig.extension.api.project.timeline.AudioClip audioClip, MainSequencer mainSequencer) {
        super(ejc2, audioClip);
        this.wFl = mainSequencer;
    }

    @Override
    public void w2Z(String string, Attributes attributes) {
        super.w2Z(string, attributes);
        if (string.equalsIgnoreCase("WarpMarkers/WarpMarker")) {
            double d2 = this.bsM(attributes, "SecTime");
            double d3 = this.bsM(attributes, "BeatTime");
            if (d2 >= 0.0) {
                this.w2Z.add(new pdu(this, d2, d3));
            } else {
                System.err.println("Skipping invalid warp marker found in als file with beat time " + d3 + " and sample time " + d2);
            }
        } else if (string.equalsIgnoreCase("SampleRef")) {
            this.GvW = new SampleRef(this.stE());
            this.stE().w2Z(this.GvW);
        } else if (string.equalsIgnoreCase("ModulationList/Modulations/Modulation")) {
            Modulation modulation = new Modulation(this.stE(), this.wFl, this);
            this.gFf.add(modulation);
            this.stE().w2Z(modulation);
        } else if (string.equalsIgnoreCase("PitchCoarse")) {
            this.BOK = this.rLM(attributes, "Value");
        } else if (string.equalsIgnoreCase("PitchFine")) {
            this.HaN = this.bsM(attributes, "Value");
        } else if (string.equalsIgnoreCase("SampleVolume")) {
            this.rLM = this.bsM(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fade")) {
            this.gU = this.HaN(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fades/FadeInLength")) {
            this.bsM = this.KyJ(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fades/FadeOutLength")) {
            this.KyJ = this.KyJ(attributes, "Value");
        } else if (string.equalsIgnoreCase("Fades/CrossfadeInState")) {
            this.FMt = this.rLM(attributes, "Value");
        } else if (string.equalsIgnoreCase("IsWarped")) {
            this.UN3 = this.HaN(attributes, "Value");
        } else if (string.equalsIgnoreCase("WarpMode")) {
            this.zxv = this.rLM(attributes, "Value");
        } else if (string.equalsIgnoreCase("TransientResolution")) {
            this.Bh1 = this.rLM(attributes, "Value");
        } else if (string.equalsIgnoreCase("TransientLoopMode")) {
            this.r2 = this.rLM(attributes, "Value");
        } else if (string.equalsIgnoreCase("TransientEnvelope")) {
            this.cFc = this.bsM(attributes, "Value");
        } else if (string.equalsIgnoreCase("ComplexProFormants")) {
            this.OhK = this.bsM(attributes, "Value");
        } else if (string.equalsIgnoreCase("ComplexProEnvelope")) {
            this.Gox = this.bsM(attributes, "Value");
        }
    }

    @Override
    public void w2Z(String string) {
        super.w2Z(string);
    }

    @Override
    public void w2Z() {
        double d2;
        double d3;
        super.w2Z();
        SampleReference sampleReference = this.GvW.KyJ();
        if (sampleReference == null) {
            return;
        }
        WarpMarkers warpMarkers = this.tUG().createWarpEvents();
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double d4 = !this.w2Z.isEmpty() ? ((pdu)this.w2Z.getFirst()).HaN : 0.0;
        for (pdu pdu2 : this.w2Z) {
            double d5 = pdu2.HaN - d4;
            double d6 = pdu2.BOK;
            dArray2[0] = d6 - dArray[0];
            dArray2[1] = d5 - dArray[1];
            dArray[0] = d6;
            dArray[1] = d5;
            warpMarkers.addWarpEvent(d5, d6);
        }
        double d7 = 0.0;
        if (!this.w2Z.isEmpty()) {
            pdu pdu3 = (pdu)this.w2Z.getLast();
            if (this.GvW.HaN()) {
                double d8 = this.GvW.rLM();
                d3 = d8 - pdu3.BOK;
                d7 = pdu3.HaN + d3 * dArray2[1] / dArray2[0] - d4;
                if (d3 > 0.0) {
                    warpMarkers.addWarpEvent(d7, d8);
                }
            } else {
                d7 = pdu3.HaN - d4;
            }
        }
        this.X3Z = this.tUG().createAudioNote(d4, d7, sampleReference);
        this.X3Z.setWarpEvents(warpMarkers);
        if (this.GvW.UN3() != null) {
            this.X3Z.analyzeOnsets(this.GvW.UN3());
        }
        if ((d2 = this.BOK()) != 0.0) {
            this.X3Z.getTranspose().setValue(d2, Unit.SEMITONES);
        }
        if (this.rLM != 1.0) {
            this.X3Z.getGain().setValue(this.rLM, Unit.NONE);
        }
        this.w2Z(this.X3Z);
        AudioNoteTimeline audioNoteTimeline = (AudioNoteTimeline)((AudioClipContent)((com.bitwig.extension.api.project.timeline.AudioClip)this.bsM()).getContent()).getNoteTimeline();
        this.w2Z(() -> audioNoteTimeline.addEvent(this.X3Z), LvD.rLM);
        d3 = this.FMt == 1 ? -this.wFl.rLM() : this.bsM;
        this.w2Z(() -> ((com.bitwig.extension.api.project.timeline.AudioClip)this.bsM()).setFadeInTime(d3), LvD.bsM);
        ((com.bitwig.extension.api.project.timeline.AudioClip)this.bsM()).setFadeOutTime(this.KyJ);
        this.wFl.w2Z(this.KyJ);
    }

    private void w2Z(AudioNote audioNote) {
        if (!this.UN3) {
            audioNote.setWarpMode(WarpMode.RAW);
        } else if (this.zxv == 0) {
            audioNote.setWarpMode(WarpMode.SLICE);
        } else if (this.zxv == 1) {
            audioNote.setWarpMode(WarpMode.STRETCH);
        } else if (this.zxv == 2) {
            audioNote.setWarpMode(WarpMode.CYCLIC);
        } else if (this.zxv == 3) {
            audioNote.setWarpMode(WarpMode.REPITCH);
        } else if (this.zxv == 4) {
            audioNote.setWarpMode(WarpMode.ELASTIQUE);
        } else if (this.zxv == 6) {
            audioNote.setWarpMode(WarpMode.ELASTIQUE_PRO);
        }
        audioNote.setPreserveFormants(this.OhK >= 50.0);
        audioNote.setFormantEnvelopeResolution((int)this.Gox);
        if (this.Bh1 == 6) {
            audioNote.setTransientRate(TransientRate.ONSETS);
        } else if (this.Bh1 == 0) {
            audioNote.setTransientRate(TransientRate.EIGHT);
        } else if (this.Bh1 == 1) {
            audioNote.setTransientRate(TransientRate.EIGHT);
        } else if (this.Bh1 == 3) {
            audioNote.setTransientRate(TransientRate.EIGHT);
        } else if (this.Bh1 == 4) {
            audioNote.setTransientRate(TransientRate.SIXTEENTH);
        } else if (this.Bh1 == 5) {
            audioNote.setTransientRate(TransientRate.SIXTEENTH);
        }
        if (this.r2 == 2) {
            audioNote.setWarpTailMode(WarpTailMode.PINGPONG);
        } else if (this.r2 == 1) {
            audioNote.setWarpTailMode(WarpTailMode.GRAIN);
        } else if (this.r2 == 0) {
            audioNote.setWarpTailMode(WarpTailMode.NONE);
        }
    }

    public double BOK() {
        return this.BOK + this.HaN * 0.01;
    }

    public double HaN() {
        return this.rLM;
    }

    public AudioNote rLM() {
        return this.X3Z;
    }
}

