/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extensions.importer.als.elements.devices;

import com.bitwig.extension.api.project.component.Multisample;
import com.bitwig.extension.api.project.component.MultisampleZone;
import com.bitwig.extension.api.project.component.SamplerResourceComponent;
import com.bitwig.extension.api.project.component.SingleSampleResource;
import com.bitwig.extension.api.project.file.SampleReference;
import com.bitwig.extension.api.project.parameter.Unit;
import com.bitwig.extensions.importer.als.elements.MultiSampleMap;
import com.bitwig.extensions.importer.als.elements.MultiSamplePart;
import com.bitwig.extensions.importer.als.elements.NativeDevice;
import java.util.List;
import java.util.UUID;
import org.xml.sax.Attributes;

public abstract class SimplerOrSampler
extends NativeDevice {
    private MultiSampleMap HaN;
    private int rLM = 1;

    public SimplerOrSampler(ejc ejc2) {
        super(ejc2, UUID.fromString("468bc14b-b2e7-45a1-9666-e83117fe404e"));
        this.w2Z("Pitch/TransposeKey", "TRANSPOSE", Unit.SEMITONES_RELATIVE);
        this.w2Z("Filter/Slot/Value/SimplerFilter/Freq", "FILT_FREQ", Unit.HERTZ);
        this.w2Z("Filter/Slot/Value/SimplerFilter/Res", "FILT_RESO", Unit.NONE);
        this.w2Z("Filter/Slot/Value/SimplerFilter/ModByPitch", "FILTER_KEYTRACK", Unit.NONE);
        this.w2Z("VolumeAndPan/Volume", "GAIN", Unit.DECIBEL);
        this.w2Z("VolumeAndPan/VolumeVelScale", "VELOCITY_SENSITIVETY", Unit.PERCENTAGE_OF_RANGE);
        this.w2Z("VolumeAndPan/Panorama", "PAN", Unit.NONE);
        this.w2Z("VolumeAndPan/Envelope/AttackTime", "AMP_ATTACK_TIME", Unit.MILLISECONDS);
        this.w2Z("VolumeAndPan/Envelope/DecayTime", "AMP_DECAY_TIME", Unit.MILLISECONDS);
        this.w2Z("VolumeAndPan/Envelope/SustainLevel", "AMP_SUSTAIN_LEVEL", Unit.NONE);
        this.w2Z("VolumeAndPan/Envelope/ReleaseTime", "AMP_RELEASE_TIME", Unit.MILLISECONDS);
        this.w2Z("VolumeAndPan/Envelope/AttackSlope", "AMP_ATTACK_SHAPE", Unit.MILLISECONDS);
        this.w2Z("VolumeAndPan/Envelope/DecaySlope", "AMP_DECAY_SHAPE", Unit.MILLISECONDS, d2 -> -d2);
        this.w2Z("VolumeAndPan/Envelope/ReleaseSlope", "AMP_RELEASE_SHAPE", Unit.MILLISECONDS, d2 -> -d2);
        this.w2Z("Player/SampleSelector", "SELECT", Unit.MIDI128);
        this.w2Z("Player/LoopModulators/SampleStart", "SAMPLE_START", Unit.NONE);
        this.w2Z("Player/LoopModulators/LoopLength", "LOOP_LENGTH", Unit.NONE);
        this.w2Z("Globals/PortamentoTime", "POLY/GLIDE_TIME", Unit.MILLISECONDS);
    }

    @Override
    public void w2Z(String string, Attributes attributes) {
        super.w2Z(string, attributes);
        if (string.equals("Player/MultiSampleMap")) {
            this.HaN = new MultiSampleMap(this.stE());
            this.stE().w2Z(this.HaN);
        }
        if (string.equals("Globals/NumVoices")) {
            this.rLM = this.rLM(attributes, "Value");
        }
    }

    public SamplerResourceComponent HaN() {
        return (SamplerResourceComponent)((com.bitwig.extension.api.project.mixer.NativeDevice)this.BOK()).getComponent("SAMPLE", SamplerResourceComponent.class);
    }

    @Override
    public void w2Z() {
        super.w2Z();
        SamplerResourceComponent samplerResourceComponent = this.HaN();
        List list = this.HaN.HaN();
        if (list.size() == 1) {
            MultiSamplePart multiSamplePart = (MultiSamplePart)list.get(0);
            SingleSampleResource singleSampleResource = samplerResourceComponent.loadSample(multiSamplePart.gU().KyJ(), false);
            this.w2Z(multiSamplePart, singleSampleResource);
            if (this.stE().w2Z("DrumBranch")) {
                singleSampleResource.setKeyTrack(0.0);
            }
        } else {
            Multisample multisample = samplerResourceComponent.createMultisample();
            for (MultiSamplePart multiSamplePart : list) {
                SampleReference sampleReference = multiSamplePart.gU().KyJ();
                if (sampleReference == null) continue;
                MultisampleZone multisampleZone = multisample.addZone(sampleReference);
                this.w2Z(multiSamplePart, multisampleZone);
            }
        }
        ((com.bitwig.extension.api.project.mixer.NativeDevice)this.w2Z).setNumVoices(1 + this.rLM + Math.max(0, this.rLM - 7));
    }

    private void w2Z(MultiSamplePart multiSamplePart, MultisampleZone multisampleZone) {
        multisampleZone.setLowKey(multiSamplePart.HaN());
        multisampleZone.setLowKeyCf(multiSamplePart.bsM() - multiSamplePart.HaN());
        multisampleZone.setHighKey(multiSamplePart.rLM());
        multisampleZone.setHighKeyCf(multiSamplePart.rLM() - multiSamplePart.KyJ());
        multisampleZone.setLowVelocity(multiSamplePart.UN3());
        multisampleZone.setLowVelocityCf(multiSamplePart.zxv() - multiSamplePart.UN3());
        multisampleZone.setHighVelocity(multiSamplePart.JEB());
        multisampleZone.setHighVelocityCf(multiSamplePart.JEB() - multiSamplePart.Bh1());
        multisampleZone.setLowSelect(multiSamplePart.r2());
        multisampleZone.setLowSelectCf(multiSamplePart.OhK() - multiSamplePart.r2());
        multisampleZone.setHighSelect(multiSamplePart.cFc());
        multisampleZone.setHighSelectCf(multiSamplePart.cFc() - multiSamplePart.Gox());
        SingleSampleResource singleSampleResource = multisampleZone.getResource();
        this.w2Z(multiSamplePart, singleSampleResource);
    }

    protected void w2Z(MultiSamplePart multiSamplePart, SingleSampleResource singleSampleResource) {
        double d2 = multiSamplePart.gU().bsM();
        singleSampleResource.setRootKey(multiSamplePart.gFf());
        singleSampleResource.setDetune((double)multiSamplePart.GvW() * 0.01);
        singleSampleResource.setKeyTrack((double)multiSamplePart.FMt() * 0.01);
        singleSampleResource.setGain(nBT.bsM(multiSamplePart.slM()));
        singleSampleResource.setSampleStart((double)multiSamplePart.wFl() / d2);
        singleSampleResource.setSampleEnd((double)multiSamplePart.X3Z() / d2);
        double d3 = multiSamplePart.zkl() - multiSamplePart.jEl();
        singleSampleResource.setLoopStart((double)multiSamplePart.jEl() / d2);
        singleSampleResource.setLoopEnd((double)multiSamplePart.zkl() / d2);
        singleSampleResource.setLoopCrossfade(multiSamplePart.Jec() / d3);
        singleSampleResource.setLoopMode(this.w2Z(multiSamplePart.IdP()));
    }

    private bRv w2Z(int n2) {
        switch (n2) {
            case 1: {
                return bRv.BOK;
            }
            case 2: {
                return bRv.HaN;
            }
        }
        return bRv.w2Z;
    }
}

