/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing;

import com.bitwig.base.io.CouldNotDeleteDirectoryException;
import com.bitwig.base.io.mLZ;
import com.bitwig.base.platform.pdu;
import com.bitwig.base.testing.AQp;
import com.bitwig.base.testing.AnnotationBasedTest;
import com.bitwig.flt.app.testing.DsV;
import com.bitwig.flt.app.testing.OCP;
import com.bitwig.flt.app.testing.S3g;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.r2n;
import com.bitwig.flt.app.testing.uDW;
import com.bitwig.flt.app.testing.xoi;
import com.bitwig.flt.document.core.iface.suR;
import com.bitwig.flt.document.core.master.LJS;
import com.bitwig.flt.document.core.master.REs;
import com.bitwig.flt.document.core.master.YZ1;
import com.bitwig.flt.document.core.master.uDX;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class BitwigStudioTest
extends AnnotationBasedTest {
    private int mEngineRunCount = 0;

    public boolean shouldRunAsUnitTest() {
        return true;
    }

    @Override
    protected void beforeRun() {
        super.beforeRun();
        this.mEngineRunCount = 0;
    }

    @Override
    protected void afterRun() {
        super.afterRun();
        this.getApplication().dVk();
        this.addCPPAssertions();
        this.addNitroAssertions();
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void addEngineCrashes() {
        int n2 = this.mEngineRunCount;
        for (int i2 = 1; i2 <= n2; ++i2) {
            File file = this.getEngineCrashFile(i2, false);
            if (file == null || !file.canRead()) continue;
            File file2 = this.getEngineCrashInfoFile(i2, false);
            LOG.rLM("about to make engine crash bundle for: " + file.getAbsolutePath());
            String string = "engine-crash-report-" + i2;
            File file3 = this.getOutputFile(string, false);
            try {
                file3.mkdirs();
                this.getApplication().BOK(qyU.BOK(file3), file, this.getEngineLogFile(), file2);
                File file4 = this.getOutputFile(string + ".zip");
                B b2 = new B();
                b2.w2Z(file3);
                b2.BOK(file4);
                try {
                    mLZ.rLM(file3);
                }
                catch (CouldNotDeleteDirectoryException couldNotDeleteDirectoryException) {
                    LOG.BOK(couldNotDeleteDirectoryException);
                }
                file.delete();
                continue;
            }
            catch (IOException iOException) {
                LOG.HaN("failed to make engine crash report", iOException);
            }
        }
    }

    private void addNitroAssertions() {
        int n2 = this.mEngineRunCount;
        if (n2 == 0) {
            return;
        }
        WTR wTR = new WTR();
        for (int i2 = 1; i2 <= n2; ++i2) {
            Object object = this.getNitroAssertsFile(i2, false);
            try {
                wTR.w2Z((File)object);
                continue;
            }
            catch (IOException iOException) {
                LOG.HaN("Error parsing nitro assertions file " + String.valueOf(object), iOException);
            }
        }
        for (Object object : wTR.w2Z()) {
            this.addCheck(new Wa(((gZS)object).w2Z(), ((gZS)object).BOK(), ((gZS)object).HaN(), ((gZS)object).rLM(), ((gZS)object).bsM(), ((gZS)object).KyJ(), ((gZS)object).UN3()));
        }
    }

    private void addCPPAssertions() {
        AHh aHh2 = pdu.w2Z();
        if (aHh2 != null) {
            this.addCPPAssertions(aHh2);
        }
    }

    private void addCPPAssertions(AHh aHh2) {
        for (mWE mWE2 : aHh2.w2Z()) {
            this.addCheck(new vug(mWE2.w2Z(), mWE2.BOK(), mWE2.HaN(), mWE2.rLM(), mWE2.bsM(), mWE2.KyJ()));
        }
    }

    protected xoi getApplication() {
        return (xoi)this.getEventProcessor();
    }

    @Override
    public OCP getTestRunner() {
        return (OCP)super.getTestRunner();
    }

    public uDW getTestRunnerService() {
        OCP oCP = this.getTestRunner();
        if (oCP == null) {
            return null;
        }
        return (uDW)oCP.BOK().w2Z();
    }

    public int getSampleRate() {
        return 44100;
    }

    public int getBlockSize() {
        return 512;
    }

    protected File getOutputFile(String string) {
        return this.getOutputFile(string, true);
    }

    protected File getOutputFile(String string, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("test-output");
        stringBuilder.append('/');
        BitwigStudioTest.appendTestPathAsFilePath(this, stringBuilder);
        stringBuilder.append('/');
        stringBuilder.append(string);
        File file = this.getTestDataFile(stringBuilder.toString(), false).agk();
        if (bl2 && file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private static void appendTestPathAsFilePath(AQp aQp2, StringBuilder stringBuilder) {
        AQp aQp3 = aQp2.getParent();
        if (aQp3 != null) {
            BitwigStudioTest.appendTestPathAsFilePath(aQp3, stringBuilder);
            stringBuilder.append('/');
        }
        stringBuilder.append(mLZ.Gox(aQp2.getTestName()));
    }

    public File getEngineLogFile() {
        return this.getOutputFile("engine.log", false);
    }

    public void engineStarting() {
        assert (bTe.BOK(this.isEventDispatchThread()));
        ++this.mEngineRunCount;
    }

    public boolean shouldEnableNitroAssertions() {
        return true;
    }

    public String getErrorFilesPrefix() {
        return "";
    }

    public final File getNitroAssertsFile() {
        assert (bTe.BOK(this.isEventDispatchThread()));
        assert (bTe.BOK(this.mEngineRunCount > 0));
        return this.getNitroAssertsFile(this.mEngineRunCount, true);
    }

    protected File getNitroAssertsFile(int n2, boolean bl2) {
        assert (bTe.BOK(n2 > 0));
        return this.getOutputFile(this.getErrorFilesPrefix() + "nitro-asserts" + n2 + ".txt", bl2);
    }

    public final File getEngineCrashFile() {
        assert (bTe.w2Z(this.isEventDispatchThread()));
        assert (bTe.w2Z(this.mEngineRunCount > 0));
        return this.getEngineCrashFile(this.mEngineRunCount, true);
    }

    protected File getEngineCrashFile(int n2, boolean bl2) {
        assert (bTe.w2Z(n2 > 0));
        if (FK3.BOK()) {
            return null;
        }
        String string = "";
        if (FK3.w2Z()) {
            string = ".mdmp";
        }
        if (FK3.bsM()) {
            string = ".txt";
        }
        return this.getOutputFile(this.getErrorFilesPrefix() + "engine-crash-" + n2 + string, bl2);
    }

    protected File getEngineCrashInfoFile(int n2, boolean bl2) {
        assert (bTe.w2Z(n2 > 0));
        return this.getOutputFile(this.getErrorFilesPrefix() + "engine-crash-" + n2 + ".info", bl2);
    }

    protected S3g getTestObject(Supplier supplier) {
        S3g s3g = this.getOptTestObject(supplier);
        this.check(s3g).OhK();
        return s3g;
    }

    protected S3g getTestObject(Supplier supplier, Class clazz) {
        S3g s3g = this.getTestObject(supplier);
        return (S3g)this.cast(s3g, clazz);
    }

    protected S3g getOptTestObject(Supplier supplier, Class clazz) {
        S3g s3g = this.getOptTestObject(supplier);
        if (s3g == null) {
            return null;
        }
        return (S3g)this.cast(s3g, clazz);
    }

    protected S3g getOptTestObject(Supplier supplier) {
        Object object = this.getOpt(supplier);
        if (object == null) {
            return null;
        }
        return r2n.w2Z(this, object);
    }

    public S3g createTestObject(Object object) {
        return r2n.w2Z(this, object);
    }

    public S3g createTestObject(Object object, Class clazz) {
        S3g s3g = r2n.w2Z(this, object);
        return (S3g)this.cast(s3g, clazz);
    }

    protected TestProject createTestProject(int n2, int n3) {
        assert (bTe.BOK(!this.isEventDispatchThread()));
        com.bitwig.base.async.xoi xoi2 = new com.bitwig.base.async.xoi();
        this.getApplication().asyncExec(() -> this.getApplication().w2Z(this.getTestName(), n2, n3, new DsV(this), xoi2));
        REs rEs = (REs)this.waitForAsyncTask("New document", xoi2, 5L, TimeUnit.SECONDS);
        TestProject testProject = new TestProject(this, rEs);
        this.openedProject(testProject);
        return testProject;
    }

    protected TestProject createTestProject() {
        return this.createTestProject(0, 0);
    }

    protected TestAudioNoteClipEvent createAudioNoteClipEvent(double d2, double d3) {
        xad xad2 = xad.w2Z(d2, d3);
        xad2.DYI().BOK(true);
        return (TestAudioNoteClipEvent)this.createTestObject(xad2, TestAudioNoteClipEvent.class);
    }

    protected TestInstrumentNoteClipEvent createInstrumentNoteClipEvent(double d2, double d3) {
        return (TestInstrumentNoteClipEvent)this.createTestObject(wow.w2Z(d2, d3), TestInstrumentNoteClipEvent.class);
    }

    protected TestAudioNoteEvent createDummyAudioNoteEvent(double d2, double d3) {
        String string = "dummy";
        uDX uDX2 = uDX.w2Z("dummy", "", 2.0, 44100, 2);
        LJS lJS = LJS.w2Z("dummy", uDX2, 0L);
        lJS.rLM("somewhere_on_my_disk");
        lJS.w2Z((suR)YZ1.w2Z("/mnt/a/dummy"));
        return (TestAudioNoteEvent)this.createTestObject(yDX.w2Z(d2, d3, uDX2), TestAudioNoteEvent.class);
    }

    protected void openedProject(TestProject testProject) {
        uDW uDW2 = this.getTestRunnerService();
        if (uDW2.X3Z()) {
            testProject.cFc();
        }
    }

    @Override
    protected AQp createChild() {
        BitwigStudioTest bitwigStudioTest = (BitwigStudioTest)super.createChild();
        bitwigStudioTest.mEngineRunCount = 0;
        return bitwigStudioTest;
    }

    public long getUndoCountLimit() {
        return 25L;
    }
}

