/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestCueMarkerTimeline;
import com.bitwig.flt.app.testing.TestLoopRegion;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.AudioRecordingTests;
import java.io.File;

@OCP(w2Z="Unreliable")
public class ArrangerAudioRecordingTests
extends AudioRecordingTests {
    @Override
    protected void beforeRecording(TestProject testProject, TestTrack testTrack) {
        testProject.UN3().BOK(true);
    }

    @Override
    protected TestAudioNoteClipEvent getRecordedClip(TestTrack testTrack) {
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.r2();
        this.check("clip count", testNoteClipEventTimeline.UN3()).w2Z(1);
        TestAudioNoteClipEvent testAudioNoteClipEvent = (TestAudioNoteClipEvent)this.cast(testNoteClipEventTimeline.BOK(0), TestAudioNoteClipEvent.class);
        return testAudioNoteClipEvent;
    }

    @QTJ(rLM=false)
    public void testRecordingAudioInLoop() {
        this.testRecordingAudioInLoop(0.0, 1);
    }

    @QTJ(rLM=false)
    public void testRecordingAudioInLoop2() {
        this.testRecordingAudioInLoop(0.0, 2);
    }

    @QTJ(rLM=false)
    public void testRecordingAudioInLoop3() {
        this.testRecordingAudioInLoop(4.0, 1);
    }

    private void testRecordingAudioInLoop(double d2, int n2) {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.cFc();
        TestCueMarkerTimeline testCueMarkerTimeline = testProject.KyJ();
        double d3 = 4.0;
        TestLoopRegion testLoopRegion = testCueMarkerTimeline.KyJ();
        testLoopRegion.rLM(d2);
        testLoopRegion.HaN(4.0);
        testCueMarkerTimeline.BOK(true);
        TestTransport testTransport = testProject.UN3();
        testTransport.BOK(true);
        double d4 = testTransport.UN3().KyJ();
        TestTrack testTrack = testProject.w2Z(G3V.BOK);
        TestTrack testTrack2 = testProject.w2Z(G3V.BOK);
        testTrack2.gFf().w2Z(testTrack.wFl());
        testTrack2.BOK(true);
        double d5 = (double)n2 * 4.0 + 2.0;
        testTransport.w2Z(d2, d5);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack2.r2();
        this.check("clip count", testNoteClipEventTimeline.UN3()).w2Z(1);
        TestAudioNoteClipEvent testAudioNoteClipEvent = (TestAudioNoteClipEvent)this.cast(testNoteClipEventTimeline.BOK(0), TestAudioNoteClipEvent.class);
        this.check("clip start time", testAudioNoteClipEvent.OhK()).w2Z(d2);
        this.check("clip end time", testAudioNoteClipEvent.Bh1()).w2Z(d2 + 4.0);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteClipEvent.w2Z(0, 0).BOK(0), TestAudioNoteEvent.class);
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.JEB();
        int n3 = testWarpEventTimeline.UN3();
        this.check(n3).equals(2);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.BOK(n3 - 1), TestWarpEvent.class);
        double d6 = testWarpEvent.OhK();
        double d7 = testWarpEvent.KyJ();
        this.check(d6).BOK(d5, this.getBlockBeatLength(d4));
        TestSampleReference testSampleReference = testAudioNoteEvent.KyJ();
        testSampleReference.JEB();
        File file = new File(testSampleReference.KyJ().KyJ().KyJ());
        this.checkAudioFile(file, d7, d6);
        testProject.wFl();
    }
}

