/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.liK;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTempoAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.pdu;
import com.bitwig.samplefile.Nr;
import com.bitwig.samplefile.S3g;
import com.bitwig.samplefile.dPu;
import com.bitwig.samplefile.eD2;
import java.io.File;

public abstract class AudioRecordingOrBouncingTests
extends BitwigStudioIntegrationTest {
    @QTJ(rLM=false)
    public void testRecordingAudio() {
        this.testRecordingAudio(0.0, 4.0, 120.0);
    }

    @QTJ(rLM=false)
    public void testRecordingShortAudio() {
        double d2 = 120.0;
        this.testRecordingAudio(0.0, Df.w2Z(this.getBlockBeatLength(120.0) * 2.0), 120.0);
    }

    private void testRecordingAudio(double d2, double d3, double d4) {
        this.checkBeatTime(d2).bsM().bsM(0.0);
        this.checkBeatTime("record duration", d3).bsM().rLM(0.0);
        TestProject testProject = this.createTestProject(1, 0);
        testProject.cFc();
        TestTransport testTransport = testProject.UN3();
        testTransport.UN3().w2Z(d4);
        TestTrack testTrack = testProject.w2Z(G3V.BOK);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, d2, d3, pdu.w2Z);
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, d3, this.getExpectedDurationInBeatsTolerance(d4), this.getExpectedRecordedFile(), pdu.w2Z);
        testProject.wFl();
    }

    protected File getExpectedRecordedFile() {
        return null;
    }

    @QTJ(rLM=false)
    public void testRecordingAudioWithIOErrorOnOpen() {
        this.testRecordingAudioWithError(pdu.BOK);
    }

    @QTJ(rLM=false)
    public void testRecordingAudioWithIOErrorOnWrite() {
        this.testRecordingAudioWithError(pdu.HaN);
    }

    @QTJ(rLM=false)
    public void testRecordingAudioWithIOErrorOnClose() {
        this.testRecordingAudioWithError(pdu.rLM);
    }

    private void testRecordingAudioWithError(pdu pdu2) {
        double d2;
        double d3;
        this.check(pdu2 != pdu.w2Z);
        this.check("no error with recording audio so far", this.getFirstNotificationOfType(this.getErrorNotificationType())).cFc();
        TestProject testProject = this.createTestProject(1, 0);
        testProject.cFc();
        double d4 = testProject.UN3().UN3().KyJ();
        TestTrack testTrack = testProject.w2Z(G3V.BOK);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 4.0, pdu2);
        if (pdu2 == pdu.BOK || pdu2 == pdu.HaN) {
            d3 = 0.0;
            d2 = 0.0;
        } else {
            d3 = 0.0;
            d2 = 0.0;
        }
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d4, 4.0, this.getExpectedDurationInBeatsTolerance(d4), d3, d2, this.getExpectedRecordedFile(), pdu2);
        this.check("error notification was shown", this.getFirstNotificationOfType(this.getErrorNotificationType())).OhK();
        testProject.wFl();
    }

    @QTJ(rLM=false)
    public void testRecordingAudioWithTempoAutomation() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.cFc();
        TestTransport testTransport = testProject.UN3();
        testTransport.UN3().cFc();
        TestTrack testTrack = testProject.w2Z(G3V.BOK);
        TestTempoAutomationEventTimeline testTempoAutomationEventTimeline = (TestTempoAutomationEventTimeline)this.cast(testProject.JEB().r2().BOK(testTransport.UN3()).KyJ(), TestTempoAutomationEventTimeline.class);
        double d2 = 120.0;
        int n2 = 24;
        double d3 = 200.0;
        int n3 = 8;
        int n4 = 16;
        int n5 = 4;
        testTempoAutomationEventTimeline.w2Z(0.0, 120.0);
        testTempoAutomationEventTimeline.w2Z(8.0, 200.0);
        testTempoAutomationEventTimeline.w2Z(16.0, 200.0);
        testTempoAutomationEventTimeline.w2Z(24.0, 120.0);
        int n6 = 66;
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 24.0, pdu.w2Z);
        this.check("recorded clip", testAudioNoteClipEvent).OhK();
        this.check("start time", testAudioNoteClipEvent.OhK()).w2Z(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.w2Z(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.UN3()).w2Z(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.BOK(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.OhK()).w2Z(0.0);
        this.check(!testAudioNoteEvent.cFc());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.JEB();
        TestSampleReference testSampleReference = testAudioNoteEvent.KyJ();
        testSampleReference.JEB();
        this.check("warp event count", testWarpEventTimeline.UN3()).w2Z(66);
        double d4 = testSampleReference.zxv();
        double d5 = 24.0;
        this.check(!testSampleReference.UN3());
        String string = testSampleReference.KyJ().KyJ().KyJ();
        File file = new File(string);
        this.check("recorded file", file).UN3().r2().BOK(0L);
        eD2 eD22 = eD2.w2Z(qyU.HaN(file));
        double d6 = eD22.GvW();
        this.check("file duration", d6).BOK(d4, 7.0);
        Nr nr2 = eD22.Jec();
        this.check("metadata chunk", nr2).OhK();
        S3g s3g = nr2.w2Z();
        this.check("warp markers", s3g).OhK();
        int n7 = s3g.BOK();
        this.check("warp marker count", n7).w2Z(66);
        for (int i2 = 0; i2 < 32; ++i2) {
            double d7 = (double)i2 / 4.0;
            double d8 = testProject.w2Z(d7);
            this.checkWarpMarkerWithTempoAutomation(i2, s3g, testWarpEventTimeline, d7, d8);
        }
        this.checkWarpMarkerWithTempoAutomation(n7 - 1, s3g, testWarpEventTimeline, 24.0, d6);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, s3g);
        testProject.wFl();
    }

    private void checkWarpMarkerWithTempoAutomation(int n2, S3g s3g, TestWarpEventTimeline testWarpEventTimeline, double d2, double d3) {
        dPu dPu2 = s3g.w2Z(n2);
        double d4 = dPu2.BOK();
        this.check("warp marker beat time " + n2, d4).w2Z(d2, 3);
        if (n2 > 0 && n2 < s3g.BOK() - 1) {
            this.checkBeatTime("warp marker " + n2 + " beat time", d4).KyJ();
        }
        this.check("warp marker sample time " + n2, dPu2.w2Z()).w2Z(d3, 1);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.BOK(n2), TestWarpEvent.class);
        double d5 = testWarpEvent.OhK();
        this.checkBeatTime("warp event beat time " + n2, d5).bsM();
        if (n2 > 0 && n2 < s3g.BOK() - 1) {
            this.checkBeatTime("warp event beat time " + n2, d4).KyJ();
        }
        this.check("warp event sample time " + n2, testWarpEvent.KyJ()).w2Z(dPu2.w2Z());
    }

    protected abstract TestAudioNoteClipEvent recordClip(TestProject var1, TestTrack var2, double var3, double var5, pdu var7);

    protected double getExpectedDurationInBeatsTolerance(double d2) {
        return 0.0;
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, File file, pdu pdu2) {
        double d5 = d3 / d2 * 60.0;
        double d6 = d4 != 0.0 ? d4 / d2 * 60.0 : 1.0 / (double)this.getSampleRate();
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d2, d3, d4, d5, d6, file, pdu2);
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2, double d3, double d4, double d5, double d6, File file, pdu pdu2) {
        this.check("clip", testAudioNoteClipEvent).OhK();
        this.check("start time", testAudioNoteClipEvent.OhK()).w2Z(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.w2Z(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.UN3()).w2Z(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.BOK(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.OhK()).w2Z(0.0);
        this.check("!isBeingRecorded", !testAudioNoteEvent.cFc());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.JEB();
        int n2 = testWarpEventTimeline.UN3();
        this.check("warp event count", n2).w2Z(2);
        TestSampleReference testSampleReference = testAudioNoteEvent.KyJ();
        testSampleReference.JEB();
        double d7 = testSampleReference.zxv();
        if (pdu2 == pdu.w2Z) {
            this.check("sample ref duration", d7).BOK(d5, d6);
        }
        double d8 = testAudioNoteClipEvent.zxv();
        this.checkBeatTime("clip duration", d8).bsM().BOK(d3, d4);
        this.check("event duration", testAudioNoteEvent.zxv()).w2Z(d8);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.BOK(0), TestWarpEvent.class);
        this.check("first warp event time", testWarpEvent.OhK()).w2Z(0.0);
        this.check("first warp event sample time", testWarpEvent.KyJ()).w2Z(0.0);
        TestWarpEvent testWarpEvent2 = (TestWarpEvent)this.cast(testWarpEventTimeline.BOK(n2 - 1), TestWarpEvent.class);
        this.check("last warp event time", testWarpEvent2.OhK()).w2Z(d8);
        if (pdu2 == pdu.w2Z) {
            this.check("last warp event sample time", testWarpEvent2.KyJ()).w2Z(d7);
        }
        this.check(!testSampleReference.UN3());
        String string = testSampleReference.KyJ().KyJ().KyJ();
        File file2 = new File(string);
        if (file != null) {
            this.check(file.getPath()).w2Z(file2.getPath());
        }
        if (pdu2 == pdu.w2Z) {
            this.checkAudioFile(file2, d7, d8);
        }
    }

    protected void checkAudioFile(File file, double d2, double d3) {
        this.check("file", file).UN3().r2().BOK(0L);
        eD2 eD22 = eD2.w2Z(qyU.HaN(file));
        this.check("sample rate correct", eD22.gFf()).w2Z(this.getSampleRate());
        this.check("channel count correct", eD22.OhK()).w2Z(2);
        this.check("bit depth correct", eD22.Gox()).w2Z(this.getExpectedBitsPerSample());
        double d4 = eD22.GvW();
        this.check("file duration", d4).BOK(d2, 7.0);
        Nr nr2 = eD22.Jec();
        this.check("metadata chunk", nr2).OhK();
        S3g s3g = nr2.w2Z();
        this.check("warp markers", s3g).OhK();
        int n2 = s3g.BOK();
        this.check("warp marker count", n2).w2Z(2).rLM().bsM(2);
        dPu dPu2 = s3g.w2Z(0);
        this.check("first warp marker beat time", dPu2.BOK()).w2Z(0.0);
        this.check("first warp marker sample time", dPu2.w2Z()).w2Z(0.0);
        dPu dPu3 = s3g.w2Z(n2 - 1);
        this.checkBeatTime("last warp marker beat time", dPu3.BOK()).KyJ(d3);
        this.check("last warp marker sample time", dPu3.w2Z()).w2Z(d4);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, s3g);
    }

    private void checkLoadingAudioNoteHasExpectedWarpMarkers(File file, S3g s3g) {
        OKY oKY = new OKY(new liK(file));
        RPP rPP = (RPP)this.get(() -> aTQ.w2Z().w2Z(false, false, false));
        int n2 = 60;
        oKY.w2Z(60.0, rPP, false, true, true, true, 50.0f, 180.0f, 0.25);
        S3g s3g2 = oKY.rLM();
        this.check("loaded sample info has warp markers", s3g2).OhK();
        this.checkHasSameWarpMarkers(s3g, s3g2);
        yDX yDX2 = yDX.w2Z(oKY, LVK.BOK, 60.0, true);
        Zsu zsu = yDX2.qn3().k1w();
        this.checkWarpEventsAreCorrectForWarpMarkers(zsu, s3g);
    }

    private void checkHasSameWarpMarkers(S3g s3g, S3g s3g2) {
        this.check(s3g.BOK()).rLM().w2Z(s3g2.BOK());
        for (int i2 = 0; i2 < s3g.BOK(); ++i2) {
            dPu dPu2 = s3g.w2Z(i2);
            dPu dPu3 = s3g2.w2Z(i2);
            this.check("Warp marker " + (i2 + 1) + " is the same", dPu2).w2Z(dPu3);
        }
    }

    private void checkWarpEventsAreCorrectForWarpMarkers(Zsu zsu, S3g s3g) {
        int n2 = zsu.tUG();
        int n3 = s3g.BOK();
        this.check("warp event count is correct", n2).w2Z(n3);
        for (int i2 = 0; i2 < Math.min(n3, n2); ++i2) {
            dPu dPu2 = s3g.w2Z(i2);
            Mma mma = zsu.BOK(i2);
            this.check("Warp event " + (i2 + 1) + " beat time is correct", mma.aG2()).w2Z(Df.w2Z(dPu2.BOK()));
            this.check("Warp event " + (i2 + 1) + " sample time is correct", mma.rLM()).w2Z(dPu2.w2Z());
        }
    }

    protected abstract int getExpectedBitsPerSample();

    protected abstract Class getErrorNotificationType();
}

