/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.flt.app.testing.TE1;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioSource;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.tests.AudioRecordingOrBouncingTests;
import com.bitwig.flt.app.testing.tests.pdu;
import java.io.File;
import java.util.Collection;

public abstract class BounceTests
extends AudioRecordingOrBouncingTests {
    private BLt mSampleBitDepth;
    private Boolean mShouldBounceInRealtime;

    @Override
    public String getTestName() {
        if (this.mShouldBounceInRealtime != null) {
            if (this.mSampleBitDepth == null) {
                return this.mShouldBounceInRealtime != false ? "realtime" : "offline";
            }
        } else {
            return this.getClass().getSimpleName();
        }
        return super.getTestName();
    }

    @Override
    protected String getMethodNodeName() {
        return this.mSampleBitDepth.BOK();
    }

    @Override
    protected void listChildren(Collection collection) {
        if (this.mShouldBounceInRealtime == null) {
            BounceTests bounceTests = (BounceTests)this.createChild();
            bounceTests.mShouldBounceInRealtime = Boolean.FALSE;
            collection.add(bounceTests);
            BounceTests bounceTests2 = (BounceTests)this.createChild();
            bounceTests2.mShouldBounceInRealtime = Boolean.TRUE;
            collection.add(bounceTests2);
        } else if (this.mSampleBitDepth == null) {
            for (BLt bLt2 : BLt.values()) {
                BounceTests bounceTests = (BounceTests)this.createChild();
                bounceTests.mSampleBitDepth = bLt2;
                collection.add(bounceTests);
            }
        } else {
            super.listChildren(collection);
        }
    }

    @Override
    protected TestAudioNoteClipEvent recordClip(TestProject testProject, TestTrack testTrack, double d2, double d3, pdu pdu2) {
        File file = this.getExpectedRecordedFile();
        file.delete();
        TestAudioSource testAudioSource = testTrack.GvW();
        VcM vcM = (VcM)this.get(() -> this.createBounceRequest((Kdq)testAudioSource.rLM(), d2, d3, file));
        vcM.w2Z(pdu2.ordinal());
        try {
            TestAudioNoteClipEvent testAudioNoteClipEvent = testAudioSource.w2Z(vcM, this.mSampleBitDepth, this.mShouldBounceInRealtime);
            if (pdu2 != pdu.w2Z) {
                this.fail("Should have reported error bouncing");
            }
            return testAudioNoteClipEvent;
        }
        catch (TE1 tE12) {
            if (pdu2 == pdu.w2Z) {
                throw tE12;
            }
            return tE12.w2Z();
        }
    }

    protected abstract VcM createBounceRequest(Kdq var1, double var2, double var4, File var6);

    @Override
    protected File getExpectedRecordedFile() {
        return this.getOutputFile(String.valueOf(this.mSampleBitDepth) + (this.mShouldBounceInRealtime != false ? "-realtime" : "") + ".wav", false);
    }

    @Override
    protected int getExpectedBitsPerSample() {
        switch (this.mSampleBitDepth) {
            case HaN: {
                return 32;
            }
            case w2Z: {
                return 16;
            }
            case BOK: {
                return 24;
            }
        }
        this.fail("Unknown sample bit depeth");
        return 0;
    }

    @Override
    protected Class getErrorNotificationType() {
        return AcR.class;
    }
}

