/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestChainSelector;
import com.bitwig.flt.app.testing.TestChainSelectorIndexedValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestEnumAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestIndexedValueAtom;
import com.bitwig.flt.app.testing.TestIndexedValueType;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestNestedDeviceChain;
import com.bitwig.flt.app.testing.TestPermanentAutomationLane;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import com.bitwig.flt.app.testing.TestTrackOrTrackGroup;
import com.bitwig.flt.app.testing.l2R;
import com.bitwig.flt.document.core.master.device.eD2;
import java.util.UUID;

public abstract class ChainSelectorTests
extends BitwigStudioIntegrationTest {
    @Override
    public long getUndoCountLimit() {
        return 75L;
    }

    protected abstract UUID getDeviceId();

    protected abstract G3V getTrackType();

    private TestChainSelector createAndGetChainSelector() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        return (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
    }

    @QTJ
    public void checkAddDeleteSimple() {
        TestChainSelector testChainSelector = this.createAndGetChainSelector();
        this.check("ChainSelectorEmpty", testChainSelector.JEB()).w2Z(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.KyJ().UN3()).w2Z(0);
        testChainSelector.UN3();
        this.check("ChainSelectorEmpty", testChainSelector.JEB()).w2Z(1);
        this.check("SelectedIndexWhileEmpty", testChainSelector.KyJ().UN3()).w2Z(0);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.HaN(0);
        testNestedDeviceChain.W_();
        this.check("ChainSelectorEmpty", testChainSelector.JEB()).w2Z(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.KyJ().UN3()).w2Z(0);
    }

    @QTJ
    public void checkAddDeleteComplex() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.UN3();
            this.check("chainCount", testChainSelector.JEB()).w2Z(i2 + 1);
            String string = "Test Chain " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain = testChainSelector.HaN(i2);
            testNestedDeviceChain.BOK(string);
            this.check("title", testNestedDeviceChain.UN3()).w2Z(string);
            this.check("displayedTitle", testNestedDeviceChain.JEB()).w2Z(string);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.KyJ();
        this.check("indexInit", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelector.UN3();
        this.check("indexAfterAddChain", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        this.check("chainCount", testChainSelector.JEB()).w2Z(6);
        testChainSelector.HaN(0).W_();
        this.check("indexAfterRemoveChain", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        this.check("chainCount", testChainSelector.JEB()).w2Z(5);
        testChainSelector.HaN(1).W_();
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        this.check("chainCount", testChainSelector.JEB()).w2Z(4);
        testChainSelectorIndexedValueAtom.BOK(2);
        testChainSelector.HaN(0).W_();
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        this.check("chainCount", testChainSelector.JEB()).w2Z(3);
        testChainSelectorIndexedValueAtom.BOK(2);
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        testChainSelector.HaN(2).W_();
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        this.check("chainCount", testChainSelector.JEB()).w2Z(2);
    }

    @QTJ
    public void checkMoveToFirst() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.UN3();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.KyJ();
        testChainSelectorIndexedValueAtom.BOK(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.HaN(0);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.HaN(2);
        testNestedDeviceChain.cFc().w2Z(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.JEB()).w2Z(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).w2Z(testChainSelector.HaN(0));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).w2Z(testChainSelector.HaN(1));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
    }

    public void checkMoveToLast() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.UN3();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.KyJ();
        testChainSelectorIndexedValueAtom.BOK(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.HaN(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.HaN(2);
        testNestedDeviceChain.r2().w2Z(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.JEB()).w2Z(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).w2Z(testChainSelector.HaN(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).w2Z(testChainSelector.HaN(3));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.UN3()).w2Z(4);
    }

    @QTJ
    public void checkDuplicate() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.UN3();
        }
        testTrack.V_().Bh1();
        TestTrackGroup testTrackGroup = testProject.JEB();
        TestTrackOrTrackGroup testTrackOrTrackGroup = testTrackGroup.BOK(1);
        TestNativeDevice testNativeDevice2 = testTrackOrTrackGroup.zxv().HaN(0);
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.w2Z(eD2.class), TestChainSelector.class);
        this.check("chainsCount", testChainSelector2.JEB()).equals(5);
    }

    @QTJ
    public void checkPrevNextArrows() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.KyJ();
        this.check("index when empty", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index when empty after selectNextValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index when empty after selectPrevValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index when empty after cycleNextValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index when empty after cyclePrevValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelector.UN3();
        this.check("index with a single chain", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index with a single chain after selectNextValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index with a single chain after selectPrevValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index with a single chain after cycleNextValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index with a single chain after cyclePrevValue()", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelector.UN3();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index next at end", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index prev", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelector.UN3();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        testChainSelectorIndexedValueAtom.JEB();
        this.check("index next at end", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index prev", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index prev", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.zxv();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        testChainSelectorIndexedValueAtom.Bh1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(2);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(1);
        testChainSelectorIndexedValueAtom.r2();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
    }

    @QTJ
    public void checkAutomation() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.UN3();
        }
        this.check("chainCount", testChainSelector.JEB()).w2Z(5);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.KyJ();
        TestIndexedValueType testIndexedValueType = testChainSelectorIndexedValueAtom.KyJ();
        this.check("indexValueTypeIsAutomatable", testIndexedValueType.KyJ());
        this.check("indexValueTypeIsInterpolated", !testIndexedValueType.UN3());
        testChainSelectorIndexedValueAtom.cFc();
        TestPermanentAutomationLane testPermanentAutomationLane = testTrack.w2Z(testChainSelectorIndexedValueAtom);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testPermanentAutomationLane.KyJ();
        TestEnumAutomationEventTimeline testEnumAutomationEventTimeline = testArrangementAutomationTimeline.UN3();
        this.check("valueTypeEquals", testPermanentAutomationLane.w2Z(TestIndexedValueType.class)).w2Z(testIndexedValueType);
        for (int i3 = 0; i3 < 5; ++i3) {
            testEnumAutomationEventTimeline.w2Z(i3, i3);
        }
        this.check("automationHasEvents", testPermanentAutomationLane.UN3());
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.HaN(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.HaN(2);
        testNestedDeviceChain.r2().w2Z(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.JEB()).w2Z(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).w2Z(testChainSelector.HaN(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).w2Z(testChainSelector.HaN(3));
        this.check("automationEventsCount", testEnumAutomationEventTimeline.UN3()).w2Z(5);
        this.check("valueAt0", testEnumAutomationEventTimeline.w2Z(0.0).KyJ()).equals(0);
        this.check("valueAt1", testEnumAutomationEventTimeline.w2Z(1.0).KyJ()).equals(1);
        this.check("valueAt2", testEnumAutomationEventTimeline.w2Z(2.0).KyJ()).equals(3);
        this.check("valueAt3", testEnumAutomationEventTimeline.w2Z(3.0).KyJ()).equals(4);
        this.check("valueAt4", testEnumAutomationEventTimeline.w2Z(4.0).KyJ()).equals(2);
    }

    @QTJ
    public void checkMoveBetweenTwoDevices() {
        Object object;
        TestNestedDeviceChain testNestedDeviceChain;
        Object object2;
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.w2Z(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.w2Z(eD2.class), TestChainSelector.class);
        TestNativeDevice testNativeDevice2 = testDeviceChain.w2Z(1, this.getDeviceId());
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.w2Z(eD2.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.UN3();
            testChainSelector2.UN3();
            this.check("chainCount1", testChainSelector.JEB()).w2Z(i2 + 1);
            this.check("chainCount2", testChainSelector2.JEB()).w2Z(i2 + 1);
            object2 = "Test Chain1 " + (i2 + 1);
            testNestedDeviceChain = testChainSelector.HaN(i2);
            testNestedDeviceChain.BOK((String)object2);
            this.check("title", testNestedDeviceChain.UN3()).w2Z((String)object2);
            this.check("displayedTitle", testNestedDeviceChain.JEB()).w2Z((String)object2);
            object = "Test Chain2 " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector2.HaN(i2);
            testNestedDeviceChain2.BOK((String)object);
            this.check("title", testNestedDeviceChain2.UN3()).w2Z((String)object);
            this.check("displayedTitle", testNestedDeviceChain2.JEB()).w2Z((String)object);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.KyJ();
        this.check("indexInit1", testChainSelectorIndexedValueAtom.UN3()).w2Z(0);
        object2 = testChainSelector2.KyJ();
        this.check("indexInit2", ((TestIndexedValueAtom)object2).UN3()).w2Z(0);
        testChainSelectorIndexedValueAtom.BOK(2);
        ((TestIndexedValueAtom)object2).BOK(2);
        testNestedDeviceChain = testChainSelector.HaN(2);
        object = testChainSelector2.HaN(2);
        testNestedDeviceChain.r2().w2Z((l2R)object);
        this.check("index1", testChainSelector.KyJ().UN3()).w2Z(2);
        this.check("chainsCount1", testChainSelector.JEB()).w2Z(6);
        this.check("index2", testChainSelector2.KyJ().UN3()).w2Z(2);
        this.check("chainsCount2", testChainSelector2.JEB()).w2Z(4);
    }
}

