/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestClipEventTimeline;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestPolyphonicInstrumentNoteTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.document.core.master.REs;
import java.util.Random;

@OCP(w2Z="Application")
public class ClipOperationsTest
extends BitwigStudioTest {
    @Override
    public long getUndoCountLimit() {
        return 50L;
    }

    @QTJ
    public void createClip() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = this.createInstrumentNoteClipEvent(0.0, 4.0);
        TestClipEventTimeline testClipEventTimeline = (TestClipEventTimeline)this.get(testTrack::r2);
        this.exec(() -> testClipEventTimeline.w2Z(testInstrumentNoteClipEvent));
        this.check("clip count", testClipEventTimeline.UN3()).w2Z(1);
    }

    @QTJ
    public void createClipWithNotes() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = this.createInstrumentNoteClipEvent(0.0, 4.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = (TestNoteClipEventTimeline)this.get(testTrack::r2);
        testNoteClipEventTimeline.w2Z(testInstrumentNoteClipEvent);
        this.check("clip count", testNoteClipEventTimeline.UN3()).w2Z(1);
        TestPolyphonicInstrumentNoteTimeline testPolyphonicInstrumentNoteTimeline = testInstrumentNoteClipEvent.UN3();
        int n2 = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            int n3 = 36 + i2;
            JFM jFM = JFM.w2Z((double)i2 * 0.25, 0.25, 0.7f);
            testInstrumentNoteClipEvent.w2Z(jFM, 0, n3);
        }
        this.check("note count", testPolyphonicInstrumentNoteTimeline.KyJ()).w2Z(16);
    }

    @QTJ
    public void createLotsOfTracksWithClipWithNotes() {
        TestProject testProject = this.createTestProject(8, 0);
        int n2 = 8;
        int n3 = 8;
        int n4 = 256;
        Random random = new Random(2000L);
        jTW jTW2 = (jTW)this.get(() -> ((REs)testProject.rLM()).Nfb().lLk().ZTj());
        for (int i2 = 0; i2 < 8; ++i2) {
            TestTrack testTrack = testProject.w2Z(G3V.w2Z);
            TestNoteClipEventTimeline testNoteClipEventTimeline = (TestNoteClipEventTimeline)this.get(testTrack::r2);
            for (int i3 = 0; i3 < 8; ++i3) {
                double d2 = 16.0;
                double d3 = 16.0 * (double)i3;
                TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = this.createInstrumentNoteClipEvent(d3, 16.0);
                testNoteClipEventTimeline.w2Z(testInstrumentNoteClipEvent);
                this.exec(() -> {
                    testInstrumentNoteClipEvent.HaN("Add notes to clip");
                    for (int i2 = 0; i2 < 256; ++i2) {
                        double d2 = Df.w2Z(16.0 * random.nextDouble());
                        boolean bl2 = false;
                        int n2 = 36 + (int)(60.0 * random.nextDouble());
                        float f2 = random.nextFloat();
                        JFM jFM = JFM.w2Z(d2, 0.25, f2);
                        ((wow)testInstrumentNoteClipEvent.rLM()).BOK(jFM, jTW2, 0, n2);
                    }
                    testInstrumentNoteClipEvent.FMt();
                });
            }
        }
        testProject.w2Z(300L);
    }
}

