/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAudioClipTakeLane;
import com.bitwig.flt.app.testing.TestAudioNoteClipContentTimeline;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;

@OCP(w2Z="Application")
public class CompRegionTests
extends BitwigStudioTest {
    private TestAudioNoteClipEvent createProjectWithAudioClip(double d2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.BOK);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createAudioNoteClipEvent(0.0, d2);
        testTrack.r2().w2Z(testAudioNoteClipEvent);
        this.check("clip count", testTrack.r2().UN3()).w2Z(1);
        return testAudioNoteClipEvent;
    }

    private TestAudioClipTakeLane addTakeLane(TestAudioNoteClipEvent testAudioNoteClipEvent, double d2) {
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        TestAudioNoteEvent testAudioNoteEvent = this.createDummyAudioNoteEvent(0.0, d2);
        TestAudioClipTakeLane testAudioClipTakeLane = testAudioNoteClipContentTimeline.w2Z(d2);
        testAudioClipTakeLane.r2().w2Z(testAudioNoteEvent);
        return testAudioClipTakeLane;
    }

    @QTJ
    public void testMultiplex() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 32.0);
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(1);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(1);
        testAudioClipTakeLane.w2Z(8.0);
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(4);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(1);
        for (int i2 = 0; i2 < 4; ++i2) {
            TestAudioClipTakeLane testAudioClipTakeLane2 = testAudioNoteClipContentTimeline.BOK(i2);
            this.check(testAudioClipTakeLane2.JEB()).w2Z(0.0, 6);
            this.check(testAudioClipTakeLane2.zxv()).w2Z((double)(8 * (3 - i2)), 6);
            this.check(testAudioClipTakeLane2.Bh1()).w2Z(8.0, 6);
        }
    }

    @QTJ
    public void testStoreAsLane() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioNoteEvent testAudioNoteEvent = this.createDummyAudioNoteEvent(8.0, 8.0);
        testAudioNoteClipContentTimeline.BOK(true).w2Z(testAudioNoteEvent);
        testAudioNoteClipContentTimeline.JEB();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(1);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(1);
    }

    @QTJ
    public void testDeleteTake() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(1);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(1);
        testAudioClipTakeLane.KyJ();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
    }

    @QTJ
    public void testDeleteTake2() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 16.0);
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(2);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(2);
        testAudioClipTakeLane.KyJ();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(1);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(1);
    }

    @QTJ
    public void testDeleteAll() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 16.0);
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(2);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(2);
        testAudioClipTakeLane.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
    }

    @QTJ
    public void testSelectTake() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        testAudioNoteClipContentTimeline.w2Z(testAudioClipTakeLane, 2.0, 6.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = testAudioNoteClipContentTimeline.UN3();
        this.check(testAudioNoteEventTimeline.JEB()).w2Z(1);
        this.check(testAudioNoteEventTimeline.KyJ()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.KyJ().JEB()).w2Z(1);
        this.check(testAudioNoteClipContentTimeline.KyJ().KyJ()).w2Z(0);
    }

    @QTJ
    public void testSelectTakes() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        testAudioNoteClipContentTimeline.w2Z(testAudioClipTakeLane, 2.0, 6.0);
        testAudioNoteClipContentTimeline.w2Z(testAudioClipTakeLane2, 4.0, 5.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = testAudioNoteClipContentTimeline.UN3();
        this.check(testAudioNoteEventTimeline.JEB()).w2Z(3);
        this.check(testAudioNoteEventTimeline.KyJ()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.KyJ().JEB()).w2Z(3);
        this.check(testAudioNoteClipContentTimeline.KyJ().KyJ()).w2Z(0);
    }

    @QTJ
    public void testSelectTakes2() {
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.createProjectWithAudioClip(8.0);
        TestAudioNoteClipContentTimeline testAudioNoteClipContentTimeline = testAudioNoteClipEvent.UN3();
        this.check(testAudioNoteClipContentTimeline.zxv()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.Bh1()).w2Z(0);
        TestAudioClipTakeLane testAudioClipTakeLane = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        TestAudioClipTakeLane testAudioClipTakeLane2 = this.addTakeLane(testAudioNoteClipEvent, 8.0);
        testAudioNoteClipContentTimeline.w2Z(testAudioClipTakeLane2, 4.0, 5.0);
        testAudioNoteClipContentTimeline.w2Z(testAudioClipTakeLane, 2.0, 6.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = testAudioNoteClipContentTimeline.UN3();
        this.check(testAudioNoteEventTimeline.JEB()).w2Z(1);
        this.check(testAudioNoteEventTimeline.KyJ()).w2Z(0);
        this.check(testAudioNoteClipContentTimeline.KyJ().JEB()).w2Z(1);
        this.check(testAudioNoteClipContentTimeline.KyJ().KyJ()).w2Z(0);
    }
}

