/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.async.WaitingAsyncTaskCompletedListener;
import com.bitwig.base.async.nCp;
import com.bitwig.base.io.cze;
import com.bitwig.base.io.ssj;
import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.tests.cw;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

@OCP(w2Z="Controllers")
public class ControllerTests
extends BitwigStudioIntegrationTest {
    private static final cw[] DRIVERS_TO_IGNORE = new cw[]{new cw("Arturia", "KeyLab Essential Mk3"), new cw("Arturia", "MiniLab 3")};
    private String mVendor;
    private gCH mDefinition;

    @QTJ
    public void checkHelpFileExists() {
        ssj ssj2;
        if (this.mDefinition.cFc() && (ssj2 = this.mDefinition.w2Z(this.getApplication().w_())) instanceof cze) {
            cze cze2 = (cze)ssj2;
            File file = cze2.w2Z();
            this.check("help file exists", file.isFile());
        }
    }

    @QTJ
    public void checkCanAutoDetectUsingMidiPortNames() {
        if (!(this.mDefinition.HaN().equals("Generic") || this.mDefinition.gFf() <= 0 && this.mDefinition.GvW() <= 0)) {
            List list = this.mDefinition.Bh1();
            this.check("Has discoverable driver name pairs", !list.isEmpty());
        }
    }

    @QTJ(HaN=-1)
    public void checkCanStartStopAndRestart() {
        if (this.mDefinition.HaN().contains("Nektar")) {
            return;
        }
        if (this.mDefinition.gFf() > 0 || this.mDefinition.GvW() > 0 || this.mDefinition.zxv() > 0) {
            WaitingAsyncTaskCompletedListener waitingAsyncTaskCompletedListener = new WaitingAsyncTaskCompletedListener();
            this.asyncExec(() -> this.getApplication().w2Z(this.mDefinition, (nCp)waitingAsyncTaskCompletedListener));
            this.waitForAsyncTask("Controller to initialize", waitingAsyncTaskCompletedListener, 15L, TimeUnit.SECONDS);
        }
    }

    @Override
    public String getTestName() {
        if (this.mDefinition != null) {
            qyU qyU2 = this.mDefinition.r2();
            if (qyU2 == null) {
                return ControllerTests.validTestName(this.mDefinition.rLM() + " (builtin)");
            }
            return ControllerTests.validTestName(this.mDefinition.rLM() + " (" + qyU2.JEB() + ")");
        }
        if (this.mVendor != null) {
            return this.mVendor;
        }
        return super.getTestName();
    }

    @Override
    protected boolean hasChildrenPerTestMethod() {
        return this.mDefinition == null;
    }

    @Override
    protected void listChildrenPerTestMethod(Collection collection) {
        jib jib2 = (jib)this.get(() -> this.getApplication().GBw());
        if (this.mVendor == null) {
            jib2.rLM();
        }
        List list = (List)this.get(jib2::bsM);
        list.removeIf(this::shouldIgnoreTestForController);
        if (this.mVendor == null) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (gCH object2 : list) {
                object = object2.HaN();
                if (arrayList.contains(object)) continue;
                arrayList.add((String)object);
            }
            Collections.sort(arrayList);
            for (String string : arrayList) {
                object = (ControllerTests)this.createChild();
                ((ControllerTests)object).mVendor = string;
                collection.add(object);
            }
        } else {
            for (gCH gCH2 : list) {
                String string = gCH2.HaN();
                if (!string.equals(this.mVendor)) continue;
                ControllerTests controllerTests = (ControllerTests)this.createChild();
                controllerTests.mDefinition = gCH2;
                collection.add(controllerTests);
            }
        }
    }

    private boolean shouldIgnoreTestForController(gCH gCH2) {
        if (gCH2 instanceof xPa && gCH2.HaN().equals("Nektar")) {
            return true;
        }
        for (cw cw3 : DRIVERS_TO_IGNORE) {
            if (!cw3.w2Z.equals(gCH2.HaN()) || !cw3.BOK.equals(gCH2.rLM())) continue;
            return true;
        }
        return false;
    }
}

