/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.async.xoi;
import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.rKC;
import java.util.concurrent.TimeUnit;

@OCP(w2Z="Controllers")
public class MidiExpressionEvaluationTests
extends BitwigStudioIntegrationTest {
    @QTJ
    public void testEvaluteStatus() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.testEvaluation("status", i2, 0, 0, i2);
        }
    }

    @QTJ
    public void testEvaluteData1() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.testEvaluation("data1", 0, i2, 0, i2);
        }
    }

    @QTJ
    public void testEvaluteData2() {
        for (int i2 = 0; i2 < 128; ++i2) {
            this.testEvaluation("data2", 0, 0, i2, i2);
        }
    }

    @QTJ
    public void testEvaluateEvent() {
        this.testEvaluation("event", 1, 2, 3, 66051);
    }

    @QTJ
    public void testEvaluateBoolAnd() {
        this.testEvaluation("true && false", 0, 0, 0, 0);
        this.testEvaluation("true && true", 0, 0, 0, 1);
        this.testEvaluation("false && false", 0, 0, 0, 0);
        this.testEvaluation("false && true", 0, 0, 0, 0);
    }

    @QTJ
    public void testEvaluateBoolOr() {
        this.testEvaluation("true || false", 0, 0, 0, 1);
        this.testEvaluation("true || true", 0, 0, 0, 1);
        this.testEvaluation("false || false", 0, 0, 0, 0);
        this.testEvaluation("false || true", 0, 0, 0, 1);
    }

    @QTJ
    public void testEvaluateEquals() {
        this.testEvaluation("status == 10", 10, 0, 0, 1);
        this.testEvaluation("status == 10", 5, 0, 0, 0);
        this.testEvaluation("10 == status", 10, 0, 0, 1);
        this.testEvaluation("10 == status", 5, 0, 0, 0);
    }

    @QTJ
    public void testEvaluateNotEquals() {
        this.testEvaluation("status != 10", 10, 0, 0, 0);
        this.testEvaluation("status != 10", 5, 0, 0, 1);
        this.testEvaluation("10 != status", 10, 0, 0, 0);
        this.testEvaluation("10 != status", 5, 0, 0, 1);
    }

    @QTJ
    public void testEvaluateLessThan() {
        this.testEvaluation("status < data1", 10, 10, 0, 0);
        this.testEvaluation("status < data1", 10, 11, 0, 1);
    }

    @QTJ
    public void testEvaluateLessThanEquals() {
        this.testEvaluation("status <= data1", 10, 9, 0, 0);
        this.testEvaluation("status <= data1", 10, 10, 0, 1);
        this.testEvaluation("status <= data1", 10, 11, 0, 1);
    }

    @QTJ
    public void testEvaluateGreaterThan() {
        this.testEvaluation("status > data1", 10, 10, 0, 0);
        this.testEvaluation("status > data1", 11, 10, 0, 1);
    }

    @QTJ
    public void testEvaluateGreaterThanEquals() {
        this.testEvaluation("status >= data1", 9, 10, 0, 0);
        this.testEvaluation("status >= data1", 10, 10, 0, 1);
        this.testEvaluation("status >= data1", 11, 10, 0, 1);
    }

    @QTJ
    public void testEvaluateIsCCValueExpression() {
        this.testEvaluation(jk.w2Z(0, 32, 16), 176, 32, 16, 1);
        this.testEvaluation(jk.w2Z(7, 32, 16), 183, 32, 16, 1);
        this.testEvaluation(jk.w2Z(0, 32, 16), 177, 32, 16, 0);
        this.testEvaluation(jk.w2Z(0, 32, 16), 192, 32, 16, 0);
        this.testEvaluation(jk.w2Z(0, 32, 16), 176, 33, 16, 0);
        this.testEvaluation(jk.w2Z(0, 32, 16), 176, 32, 17, 0);
    }

    private void testEvaluation(String string, int n2, int n3, int n4, int n5) {
        this.testEvaluation(string, new qzq(n2, n3, n4), n5);
    }

    private void testEvaluation(String string, qzq qzq2, int n2) {
        rKC rKC2 = this.getApplication();
        jk jk2 = jk.BOK(string);
        int n3 = jk2.BOK(qzq2);
        this.check("java result", n3).w2Z(n2);
        xoi xoi2 = new xoi();
        rKC2.w2Z(jk2, qzq2, xoi2);
        int n4 = (Integer)this.waitForAsyncTask("Evaluate " + string + " with status = " + qzq2.Gox() + " data1 = " + qzq2.gFf() + " data2 = " + qzq2.GvW(), xoi2, 5L, TimeUnit.SECONDS);
        this.check("engine result", n4).w2Z(n2);
    }
}

