/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestDecimalValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestModulationSourceAtom;
import com.bitwig.flt.app.testing.TestModule;
import com.bitwig.flt.app.testing.TestModuleGrid;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestValueAtom;
import com.bitwig.flt.packaging.core.AQp;
import com.bitwig.flt.packaging.core.rKC;
import java.util.UUID;

@OCP(w2Z="Devices")
public class ModuleGridTests
extends BitwigStudioIntegrationTest {
    @QTJ
    public void addAndCopyPolyGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        testNativeDevice.gFf().w2Z(testNativeDevice, rAg.BOK.HaN());
        testProject.Jec();
        testProject.IdP();
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void addFxGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.RTr);
        testNativeDevice.gFf().w2Z(testNativeDevice, rAg.BOK.HaN());
        testProject.Jec();
        testProject.IdP();
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void addAllModulesToPolyGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        testProject.jEl();
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        for (AQp aQp2 : rKC.w2Z()) {
            if (aQp2.HaN() != com.bitwig.flt.packaging.core.QTJ.HaN) continue;
            TestModule testModule = testModuleGrid.w2Z(n2, n3, aQp2.w2Z());
            n4 = Math.max(n4, testModule.OhK());
            if ((n2 += testModule.cFc()) <= 16) continue;
            n2 = 0;
            n3 += n4;
            n4 = 0;
        }
        testProject.zkl();
        testProject.w2Z(new bZO[0]);
        testProject.w2Z(300L);
    }

    @QTJ
    public void convertFilters() {
        UUID[] uUIDArray = new UUID[]{rKC.RIR, rKC.Alm, rKC.Kht, rKC.Mxk, rKC.Vru, rKC.eNZ, rKC.fWn};
        UUID uUID = rKC.eNZ;
        for (UUID uUID2 : uUIDArray) {
            if (uUID == uUID2) continue;
            this.testConvertFilter(uUID, uUID2);
        }
    }

    private void testConvertFilter(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModule testModule = testModuleGrid.w2Z(0, 3, uUID);
        TestModule testModule2 = testModuleGrid.w2Z(0, 2, rKC.rvy);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.w2Z("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        testModulationSourceAtom.w2Z(testDecimalValueAtom, 0.5);
        this.check(testModulationSourceAtom.UN3()).w2Z(1);
        testModule = testModule.w2Z(uUID2);
        this.check(testModulationSourceAtom.UN3()).w2Z(1);
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void convertOscillators() {
        UUID[] uUIDArray;
        UUID[] uUIDArray2 = uUIDArray = new UUID[]{rKC.VQy, rKC.GUw, rKC.xaw, rKC.cMX, rKC.xGn, rKC.TTi, rKC.r2a};
        int n2 = uUIDArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UUID uUID = rKC.VQy;
            UUID uUID2 = uUIDArray2[i2];
            if (uUID == uUID2) continue;
            this.testConvertOscillator(uUID, uUID2);
        }
    }

    private void testConvertOscillator(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModule testModule = testModuleGrid.w2Z(-2, 3, rKC.VQy);
        TestModule testModule2 = testModuleGrid.w2Z(0, 3, uUID);
        testModuleGrid.w2Z(testModule, "OUT", testModule2, "PHASE_IN");
        this.check("Is mapped (pre)", testModule2.BOK("PHASE_IN").KyJ());
        testModule2 = testModule2.w2Z(uUID2);
        this.check("Is mapped (post)", testModule2.BOK("PHASE_IN").KyJ());
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void convertEnvelopes() {
        UUID[] uUIDArray;
        for (UUID uUID : uUIDArray = new UUID[]{rKC.vrF, rKC.cUg, rKC.O3S, rKC.Pdl}) {
            for (UUID uUID2 : uUIDArray) {
                if (uUID == uUID2) continue;
                this.testConvertEnvelope(uUID, uUID2);
            }
        }
    }

    private void testConvertEnvelope(UUID uUID, UUID uUID2) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModule testModule = testModuleGrid.w2Z(0, 3, rKC.fWn);
        TestModule testModule2 = testModuleGrid.w2Z(0, 2, uUID);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.w2Z("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.w2Z("CONTENTS/ENVELOPE", TestModulationSourceAtom.class);
        testModulationSourceAtom.w2Z(testDecimalValueAtom, 0.5);
        this.check("Pre count", testModulationSourceAtom.UN3()).w2Z(1);
        testModule2 = testModule2.w2Z(uUID2);
        TestModulationSourceAtom testModulationSourceAtom2 = (TestModulationSourceAtom)testModule2.w2Z("CONTENTS/ENVELOPE", TestModulationSourceAtom.class);
        this.check("Post count", testModulationSourceAtom2.UN3()).w2Z(1);
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void convertLFOsWithAuxiliaryModulation() {
        UUID[] uUIDArray;
        for (UUID uUID : uUIDArray = new UUID[]{rKC.rvy, rKC.kNr}) {
            for (UUID uUID2 : uUIDArray) {
                for (UUID uUID3 : uUIDArray) {
                    for (UUID uUID4 : uUIDArray) {
                        if (uUID == uUID2 || uUID3 == uUID4) continue;
                        this.testConvertLFOsWithAuxiliaryModulation(uUID, uUID2, uUID3, uUID4);
                    }
                }
            }
        }
    }

    private void testConvertLFOsWithAuxiliaryModulation(UUID uUID, UUID uUID2, UUID uUID3, UUID uUID4) {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModule testModule = testModuleGrid.w2Z(0, 3, rKC.fWn);
        TestModule testModule2 = testModuleGrid.w2Z(0, 2, uUID);
        TestModule testModule3 = testModuleGrid.w2Z(0, 5, uUID3);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testModule.w2Z("CONTENTS/CUTOFF", TestDecimalValueAtom.class);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule2.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestModulationSourceAtom testModulationSourceAtom2 = (TestModulationSourceAtom)testModule3.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        testModulationSourceAtom.w2Z((TestValueAtom)testDecimalValueAtom, 0.5, true, HDv.w2Z, testModulationSourceAtom2);
        this.check("Pre mod count", testModulationSourceAtom.UN3()).w2Z(1);
        this.check("Pre aux count", testModulationSourceAtom2.JEB()).w2Z(1);
        testModule2 = testModule2.w2Z(uUID2);
        testModule3 = testModule3.w2Z(uUID4);
        TestModulationSourceAtom testModulationSourceAtom3 = (TestModulationSourceAtom)testModule2.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestModulationSourceAtom testModulationSourceAtom4 = (TestModulationSourceAtom)testModule3.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        this.check("Post aux count", testModulationSourceAtom3.UN3()).w2Z(1);
        this.check("Post mod count", testModulationSourceAtom4.JEB()).w2Z(1);
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void disableLongDelayFeedback() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModule testModule = testModuleGrid.w2Z(0, 3, rKC.xaw);
        TestModule testModule2 = testModuleGrid.w2Z(-2, 3, rKC.Z1U);
        testModuleGrid.w2Z(testModule2, "OUT", testModule, "PHASE_IN");
        testModuleGrid.w2Z(testModule, "OUT", testModule2, "IN");
        testProject.w2Z(new bZO[0]);
        testModule2.BOK(false);
        testModuleGrid.w2Z(testModule, "PHASE_IN");
        testProject.Jec();
        testProject.IdP();
    }

    @QTJ
    public void deleteLongDelayFeedback() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModule testModule = testModuleGrid.w2Z(0, 3, rKC.xaw);
        TestModule testModule2 = testModuleGrid.w2Z(-2, 3, rKC.Z1U);
        testModuleGrid.w2Z(testModule2, "OUT", testModule, "PHASE_IN");
        testModuleGrid.w2Z(testModule, "OUT", testModule2, "IN");
        testProject.w2Z(new bZO[0]);
        testModule2.W_();
        testProject.Jec();
        testProject.IdP();
    }

    @QTJ
    public void copyModuleWithModulationRoutingsToSameGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestNativeDevice testNativeDevice2 = testNativeDevice.BOK("CONTENTS/POST_FX").KyJ().zxv().w2Z(0, rKC.gFf);
        TestModule testModule = testModuleGrid.w2Z(0, 2, rKC.rvy);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testNativeDevice2.w2Z("CONTENTS/FREQ", TestDecimalValueAtom.class);
        testModulationSourceAtom.w2Z(testDecimalValueAtom, 0.5);
        testProject.w2Z(new bZO[0]);
        testModuleGrid.w2Z(0, 4).w2Z(testModule, rAg.BOK.HaN());
        testProject.w2Z(new bZO[0]);
    }

    @QTJ
    public void copyModuleWithModulationRoutingsToOtherGrid() {
        TestProject testProject = this.createTestProject(8, 0);
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestTrack testTrack2 = testProject.w2Z(G3V.w2Z);
        TestDeviceChain testDeviceChain = testTrack.zxv();
        TestDeviceChain testDeviceChain2 = testTrack2.zxv();
        testTrack.BOK("Source");
        testTrack2.BOK("Dest");
        TestNativeDevice testNativeDevice = testDeviceChain.w2Z(0, rKC.xou);
        TestNativeDevice testNativeDevice2 = testDeviceChain2.w2Z(0, rKC.xou);
        TestModuleGrid testModuleGrid = testNativeDevice.IdP();
        TestModuleGrid testModuleGrid2 = testNativeDevice2.IdP();
        TestNativeDevice testNativeDevice3 = testNativeDevice.BOK("CONTENTS/POST_FX").KyJ().zxv().w2Z(0, rKC.gFf);
        TestModule testModule = testModuleGrid.w2Z(0, 2, rKC.rvy);
        TestModulationSourceAtom testModulationSourceAtom = (TestModulationSourceAtom)testModule.w2Z("CONTENTS/LFO", TestModulationSourceAtom.class);
        TestDecimalValueAtom testDecimalValueAtom = (TestDecimalValueAtom)testNativeDevice3.w2Z("CONTENTS/FREQ", TestDecimalValueAtom.class);
        testModulationSourceAtom.w2Z(testDecimalValueAtom, 0.5);
        testProject.w2Z(new bZO[0]);
        testModuleGrid2.w2Z(0, 3).w2Z(testModule, rAg.BOK.HaN());
        testProject.w2Z(new bZO[0]);
    }
}

