/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.liK;
import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAnalyzedAudioFile;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import java.io.File;
import java.io.IOException;

@OCP(w2Z="Platform")
public class OnsetAnalysisTests
extends BitwigStudioTestDataFileTest {
    @Override
    protected String getTopLevelDirectoryPath() {
        return "audio-file-analysis";
    }

    @Override
    protected boolean shouldCreateTestForFileType(WKp wKp) {
        return wKp instanceof EKu;
    }

    @QTJ
    public void testBitwigVampPluginHostOnsetAnalyzer() {
        Cn cn2 = this.getApplication().cY1();
        this.check(cn2).OhK();
        File file = cn2.UN3();
        this.check(file).bsM();
        File file2 = this.getFile().tUG();
        File file3 = this.getOutputFile("detected.onsets");
        CD cD2 = new CD(file, file3);
        cD2.w2Z(new com.bitwig.samplefile.QTJ(file2));
        this.check(file3).UN3();
        File file4 = this.getExpectedFile("onsets").tUG();
        Db.w2Z(file4);
        this.checkOnsetsAreCorrect(file3, file4);
    }

    @QTJ
    public void testOnsetAnalysisViaCache() {
        Cn cn2 = this.getApplication().cY1();
        this.check(cn2).OhK();
        File file = this.getFile().tUG();
        Ck ck2 = cn2.w2Z(new liK(file));
        this.check(ck2).OhK();
        File file2 = cn2.UN3();
        this.check(file2).bsM();
        TestAnalyzedAudioFile testAnalyzedAudioFile = new TestAnalyzedAudioFile((BitwigStudioTest)this, ck2);
        CO cO2 = testAnalyzedAudioFile.w2Z(file, file2);
        this.check(file2).bsM();
        File file3 = ck2.BOK(file2);
        this.check(cO2).OhK();
        int n2 = cO2.w2Z();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = cO2.w2Z(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = cO2.BOK(i2);
            this.check(d4).w2Z(0.0, 2.0);
            d2 = d3;
        }
        File file4 = this.getExpectedFile("onsets").tUG();
        this.checkOnsetsAreCorrect(file3, file4);
    }

    private void checkOnsetsAreCorrect(File file, File file2) {
        this.check("onsets correct", file).w2Z(file2, () -> {
            CO cO2 = this.loadOnsets(file);
            this.check(file2).UN3();
            CO cO3 = this.loadOnsets(file2);
            this.check("onset count", cO2.w2Z()).w2Z(cO3.w2Z());
            int n2 = cO2.w2Z();
            this.check(n2 > 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2;
                double d3 = cO2.w2Z(i2);
                double d4 = Math.abs(d3 - (d2 = cO3.w2Z(i2)));
                this.check(d4 < 1.0E-4);
            }
        });
    }

    private CO loadOnsets(File file) {
        CO cO2 = null;
        try {
            cO2 = Db.w2Z(file);
        }
        catch (IOException iOException) {
            this.fail("load onsets file " + file.getAbsolutePath(), iOException);
        }
        this.check(cO2).OhK();
        int n2 = cO2.w2Z();
        this.check(n2 > 0);
        double d2 = -1.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = cO2.w2Z(i2);
            this.check(d3 >= 0.0);
            this.check(d3 > d2);
            double d4 = cO2.BOK(i2);
            this.check(d4).w2Z(0.0, 2.0);
            d2 = d3;
        }
        return cO2;
    }
}

