/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioIntegrationTest;
import com.bitwig.flt.app.testing.TestArrangementAutomationTimeline;
import com.bitwig.flt.app.testing.TestInstrumentNoteClipEvent;
import com.bitwig.flt.app.testing.TestInstrumentNoteEvent;
import com.bitwig.flt.app.testing.TestMatrixSlot;
import com.bitwig.flt.app.testing.TestNoteClipEvent;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTimeSignatureEvent;
import com.bitwig.flt.app.testing.TestTimeSignatureTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;

public class SessionRecordingTests
extends BitwigStudioIntegrationTest {
    @Override
    public int getBlockSize() {
        return 1859;
    }

    @QTJ(rLM=false)
    public void testRecordingEmptyInstrumentClipToArranger() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.cFc();
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestMatrixSlot testMatrixSlot = testTrack.HaN(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.JEB(), TestInstrumentNoteClipEvent.class);
        testInstrumentNoteClipEvent.w2Z(false, false);
        TestTransport testTransport = testProject.UN3();
        double d2 = 150.0;
        testTransport.UN3().w2Z(150.0);
        testTransport.BOK(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.r2();
        this.check("clip count", testNoteClipEventTimeline.UN3()).w2Z(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.BOK(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.OhK()).w2Z(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.zxv()).bsM().BOK(16.0, this.getBlockBeatLength(150.0));
        testProject.wFl();
    }

    @QTJ(rLM=false)
    public void testRecordingTimeSignatureChangesToArranger() {
        TestProject testProject = this.openTestProject("record-time-signature-changes-from-clip-launcher-to-arranger");
        testProject.cFc();
        TestTrack testTrack = testProject.JEB().r2();
        TestNoteClipEvent testNoteClipEvent = testTrack.HaN(0).UN3();
        testNoteClipEvent.w2Z(false, false);
        TestTransport testTransport = testProject.UN3();
        testTransport.BOK(0.0, 8.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.r2();
        this.check("clip count", testNoteClipEventTimeline.UN3()).w2Z(2);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.BOK(0), TestInstrumentNoteClipEvent.class);
        this.check("clip1 start time", testInstrumentNoteClipEvent.OhK()).w2Z(0.0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.BOK(1), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("clip2 start time", testInstrumentNoteClipEvent2.OhK()).w2Z(4.0);
        TestArrangementAutomationTimeline testArrangementAutomationTimeline = testTrack.BOK(testTransport.KyJ());
        TestTimeSignatureTimeline testTimeSignatureTimeline = (TestTimeSignatureTimeline)this.cast(testArrangementAutomationTimeline.KyJ(), TestTimeSignatureTimeline.class);
        this.check("event count", testTimeSignatureTimeline.UN3()).w2Z(2);
        TestTimeSignatureEvent testTimeSignatureEvent = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.HaN(0), TestTimeSignatureEvent.class);
        this.checkBeatTime("time1", testTimeSignatureEvent.OhK()).w2Z(0.0);
        this.check("numerator1", testTimeSignatureEvent.UN3()).w2Z(4);
        this.check("denominator1", testTimeSignatureEvent.JEB()).w2Z(4);
        TestTimeSignatureEvent testTimeSignatureEvent2 = (TestTimeSignatureEvent)this.cast(testTimeSignatureTimeline.HaN(1), TestTimeSignatureEvent.class);
        this.check("time2", testTimeSignatureEvent2.OhK()).w2Z(4.0);
        this.check("numerator2", testTimeSignatureEvent2.UN3()).w2Z(3);
        this.check("denominator2", testTimeSignatureEvent2.JEB()).w2Z(4);
        testProject.wFl();
    }

    @QTJ(rLM=false)
    public void testRecordingClipWithStartMarkerNotAtTimeZero() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.cFc();
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        TestMatrixSlot testMatrixSlot = testTrack.HaN(0);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent = (TestInstrumentNoteClipEvent)this.cast(testMatrixSlot.JEB(), TestInstrumentNoteClipEvent.class);
        double d2 = 2.75;
        int n2 = 40;
        double d3 = 1.0;
        testInstrumentNoteClipEvent.w2Z(2.75);
        testInstrumentNoteClipEvent.w2Z(JFM.rLM(2.75, 1.0), 0, 40);
        testInstrumentNoteClipEvent.w2Z(false, false);
        TestTransport testTransport = testProject.UN3();
        double d4 = 150.0;
        testTransport.UN3().w2Z(150.0);
        testTransport.BOK(0.0, 16.0);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.r2();
        this.check("clip count", testNoteClipEventTimeline.UN3()).w2Z(1);
        TestInstrumentNoteClipEvent testInstrumentNoteClipEvent2 = (TestInstrumentNoteClipEvent)this.cast(testNoteClipEventTimeline.BOK(0), TestInstrumentNoteClipEvent.class);
        this.checkBeatTime("time", testInstrumentNoteClipEvent2.OhK()).w2Z(0.0);
        this.checkBeatTime("duration", testInstrumentNoteClipEvent2.zxv()).bsM().BOK(16.0, this.getBlockBeatLength(150.0));
        this.checkBeatTime("play start in recorded clip", testInstrumentNoteClipEvent2.JEB()).w2Z(2.75);
        TestNoteEventTimeline testNoteEventTimeline = testInstrumentNoteClipEvent2.UN3().w2Z(40, 0);
        int n3 = testNoteEventTimeline.UN3();
        this.check("recorded note count", n3).w2Z(1);
        TestInstrumentNoteEvent testInstrumentNoteEvent = (TestInstrumentNoteEvent)this.cast(testNoteEventTimeline.BOK(0), TestInstrumentNoteEvent.class);
        this.check("recorded note start time", testInstrumentNoteEvent.OhK()).w2Z(2.75);
        this.check("recorded note duration", testInstrumentNoteEvent.zxv()).w2Z(1.0);
        testProject.wFl();
    }
}

