/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestItemSelection;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTrackGroup;
import com.bitwig.flt.document.core.master.REs;
import java.util.ArrayList;

@OCP(w2Z="Application")
public class TrackOperationTests
extends BitwigStudioTest {
    @Override
    public long getUndoCountLimit() {
        return 75L;
    }

    @QTJ
    public void testTrackGrouping() {
        Object object;
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            object = testProject.w2Z(G3V.BOK);
            arrayList.add((TestTrack)object);
        }
        TestItemSelection testItemSelection = testProject.X3Z();
        testItemSelection.KyJ();
        for (TestTrack testTrack : arrayList) {
            testItemSelection.w2Z(testTrack);
        }
        this.check("Created Tracks", testItemSelection.UN3()).w2Z(16);
        testItemSelection.JEB();
        object = (TestTrackGroup)this.cast(testProject.JEB().BOK(0), TestTrackGroup.class);
        this.check("Tracks in TrackGroup", ((TestTrackGroup)object).Bh1()).w2Z(16);
    }

    @QTJ
    public void testTrackGroupingAndUngrouping() {
        TestProject testProject = this.createTestProject(8, 0);
        ArrayList<TestTrack> arrayList = new ArrayList<TestTrack>();
        int n2 = 24;
        for (int i2 = 0; i2 < 24; ++i2) {
            TestTrack testTrack = testProject.w2Z(G3V.BOK);
            arrayList.add(testTrack);
        }
        TestItemSelection testItemSelection = testProject.X3Z();
        testItemSelection.KyJ();
        for (TestTrack testTrackOrTrackGroup2 : arrayList) {
            testItemSelection.w2Z(testTrackOrTrackGroup2);
        }
        this.check("Created Tracks", testItemSelection.UN3()).w2Z(24);
        int n3 = testProject.JEB().Bh1();
        testItemSelection.JEB();
        TestTrackGroup testTrackGroup = (TestTrackGroup)this.cast(testProject.JEB().BOK(0), TestTrackGroup.class);
        testTrackGroup.V_();
        testItemSelection.zxv();
        int n4 = testProject.JEB().Bh1();
        this.check("Tracks Before/After", n3).w2Z(n4);
    }

    @QTJ
    public void testTrackRename() {
        this.testRenameTrack("Renamed");
    }

    @QTJ
    public void testTrackRenameInvalid() {
        String string = new String(new char[]{'\ud800', 'H', 'E', 'L', 'L', 'O'});
        this.testRenameTrack(string);
    }

    @QTJ
    public void testDuplicateTrackWithMidiAutomations() {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        this.exec(() -> {
            int n2;
            Eja eja = (Eja)testTrack.rLM();
            REs rEs = eja.FLk();
            rEs.w2Z("testDuplicateTrackWithMidiAutomations", false);
            for (int i2 = 0; i2 < 16; ++i2) {
                eja.w2Z(i2, gJ.w2Z, 0);
                eja.w2Z(i2, gJ.BOK, 0);
                for (n2 = 0; n2 < 128; ++n2) {
                    eja.w2Z(i2, gJ.HaN, n2);
                }
            }
            deQ deQ2 = eja.JkO();
            n2 = deQ2.IdP();
            for (int i3 = 0; i3 < n2; ++i3) {
                mh mh2 = deQ2.bsM(i3);
                NUH nUH = eja.BOK((Ifn)mh2);
                Drv drv2 = nUH.eN1().Jpm();
                drv2.HaN(qHY.w2Z(0.0, 0.0));
                drv2.HaN(qHY.w2Z(16.0, 127.0));
            }
            rEs.w2Z(false);
        });
        testTrack.KyJ();
        TestTrack testTrack2 = (TestTrack)testProject.JEB().BOK(1);
        this.check("Duplicated Track Exists", testTrack2).OhK();
        this.check("Automation Lane Count", testTrack2.Gox()).w2Z(testTrack.Gox());
        this.exec(() -> {
            Eja eja = (Eja)testTrack2.rLM();
            deQ deQ2 = eja.JkO();
            for (int i2 = 0; i2 < 16; ++i2) {
                this.checkMidiParameterAutomation(eja, deQ2, i2, gJ.w2Z, 0);
                this.checkMidiParameterAutomation(eja, deQ2, i2, gJ.BOK, 0);
                for (int i3 = 0; i3 < 128; ++i3) {
                    this.checkMidiParameterAutomation(eja, deQ2, i2, gJ.HaN, i3);
                }
            }
        });
    }

    private void checkMidiParameterAutomation(Eja eja, deQ deQ2, int n2, gJ gJ2, int n3) {
        mh mh2 = deQ2.BOK(n2, gJ2, n3);
        this.check("Has " + gJ2.BOK() + "/" + n3 + " Atom on channel " + n2, mh2).OhK();
        if (mh2 == null) {
            return;
        }
        NUH nUH = eja.BOK((Ifn)mh2);
        this.check("Has " + gJ2.BOK() + "/" + n3 + " AutomationLane on channel " + n2, nUH).OhK();
    }

    private void testRenameTrack(String string) {
        TestProject testProject = this.createTestProject();
        TestTrack testTrack = testProject.w2Z(G3V.w2Z);
        this.check(testTrack.UN3()).UN3();
        this.check(testTrack.JEB()).JEB();
        testTrack.BOK(string);
        this.check(testTrack.UN3()).w2Z(string);
        this.check(testTrack.JEB()).w2Z(string);
        this.check(testProject.stE());
        this.check(!testProject.tUG());
        testProject.Jec();
        this.check(testTrack.UN3()).UN3();
        this.check(testTrack.JEB()).JEB();
        this.check(testProject.tUG());
        testProject.IdP();
        this.check(testTrack.UN3()).w2Z(string);
        this.check(testTrack.JEB()).w2Z(string);
    }
}

