/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests.dnd;

import com.bitwig.base.async.AsyncUtilities;
import com.bitwig.base.async.WaitingAsyncTaskCompletedListener;
import com.bitwig.base.testing.AQp;
import com.bitwig.base.testing.OCP;
import com.bitwig.base.testing.QTJ;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.DsV;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.flt.app.testing.tests.dnd.AutoDragAndDropTests$2;
import com.bitwig.flt.app.testing.tests.dnd.RZp;
import com.bitwig.flt.app.testing.tests.dnd.TE1;
import com.bitwig.flt.app.testing.tests.dnd.aOa;
import com.bitwig.flt.app.testing.tests.dnd.cw;
import com.bitwig.flt.app.testing.tests.dnd.jsr;
import com.bitwig.flt.app.testing.tests.dnd.kln;
import com.bitwig.flt.app.testing.tests.dnd.nCp;
import com.bitwig.flt.app.testing.tests.dnd.pdu;
import com.bitwig.flt.app.testing.tests.dnd.rKC;
import com.bitwig.flt.document.core.iface.clipboard.clip.ArrangerClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.clip.ClipLauncherClipInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.DeviceChainInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.DrumPadInsertionPoint;
import com.bitwig.flt.document.core.iface.clipboard.device.uDW;
import com.bitwig.flt.document.core.iface.clipboard.track.SoS;
import com.bitwig.flt.document.core.iface.clipboard.track.TrackHeaderInsertionPoint;
import com.bitwig.flt.document.core.iface.dfU;
import com.bitwig.flt.document.core.master.REs;
import com.bitwig.flt.document.core.master.aYR;
import com.bitwig.flt.document.core.master.device.DFk;
import com.bitwig.flt.document.core.master.device.MXO;
import com.bitwig.flt.document.core.master.device.YlS;
import com.bitwig.flt.document.core.master.device.kWU;
import com.bitwig.flt.document.core.master.device.lD;
import com.bitwig.flt.document.core.master.ywn;
import com.bitwig.ramona.core.KDJ;
import com.bitwig.ramona.core.TO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

@OCP(w2Z="Unreliable")
public class AutoDragAndDropTests
extends BitwigStudioTestDataFileTest {
    private aOa mDataSourceCreator;
    private TE1 mInsertionPointCreator;
    private TestProject mProject;
    private int mInsertModifiers = -1;
    private rKC mExpectedAction;
    private jsr mExpectedInsertActionsFile;
    private static final String CORRECT_INSERT_ACTION_NAME = "insert-action";
    private static final int MODIFIERS_TO_IGNORE = 0;
    private TestProject mProjectWeOpenedToFindTestHierarchy;
    private List mAllDataSourceCreators;
    private List mAllInsertionPointCreators;

    @Override
    protected String getTopLevelDirectoryPath() {
        return "auto-drag-and-drop/projects";
    }

    @Override
    protected boolean shouldCreateTestForFileType(WKp wKp) {
        return wKp instanceof piq;
    }

    @Override
    protected boolean hasChildTestsPerFile(qyU qyU2) {
        return true;
    }

    @Override
    protected String getTestNodeNameForFile(qyU qyU2) {
        return qyU2.zxv();
    }

    @Override
    public String getTestName() {
        if (this.mDataSourceCreator != null) {
            if (this.mInsertionPointCreator != null) {
                if (this.mInsertModifiers == 0) {
                    return "none";
                }
                if (this.mInsertModifiers != -1) {
                    return rAg.rLM(this.mInsertModifiers);
                }
                return this.mInsertionPointCreator.w2Z();
            }
            return this.mDataSourceCreator.w2Z();
        }
        return super.getTestName();
    }

    @Override
    protected void listChildrenForFile(qyU qyU2, Collection collection) {
        if (this.shouldCreateTestForFile(qyU2)) {
            if (this.mDataSourceCreator == null) {
                this.listDataSourceTests(qyU2, collection);
            } else if (this.mInsertionPointCreator == null) {
                this.listInsertionPointTests(qyU2, collection);
            } else if (this.mInsertModifiers == -1) {
                this.listInsertModifierTests(qyU2, collection);
            }
        } else {
            super.listChildrenForFile(qyU2, collection);
        }
    }

    private void listDataSourceTests(qyU qyU2, Collection collection) {
        assert (bTe.BOK(this.mAllDataSourceCreators == null));
        assert (bTe.BOK(this.mAllInsertionPointCreators == null));
        assert (bTe.BOK(this.mExpectedInsertActionsFile == null));
        qyU qyU3 = qyU2.bsM(qyU2.zxv() + ".expected");
        this.mProjectWeOpenedToFindTestHierarchy = this.openTestProject(qyU2);
        this.mAllDataSourceCreators = new ArrayList();
        this.mAllInsertionPointCreators = new ArrayList();
        qyU qyU4 = this.getTopLevelDirectory().r2().KyJ("files");
        qyU4.w2Z(new pdu(this, qyU4));
        this.exec(() -> {
            REs rEs = (REs)this.mProjectWeOpenedToFindTestHierarchy.rLM();
            this.listDataSourcesAndInsertionPointsForDocument(rEs);
        });
        this.mExpectedInsertActionsFile = new jsr(qyU3, this.mAllDataSourceCreators, this.mAllInsertionPointCreators);
        this.exec(() -> {
            for (aOa aOa2 : this.mAllDataSourceCreators) {
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(qyU2, true);
                autoDragAndDropTests.mDataSourceCreator = aOa2;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertionPointTests(qyU qyU2, Collection collection) {
        assert (bTe.BOK(this.mDataSourceCreator != null));
        assert (bTe.BOK(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            REs rEs = (REs)this.mProjectWeOpenedToFindTestHierarchy.rLM();
            sA2 sA22 = this.mDataSourceCreator.w2Z(rEs);
            for (TE1 tE12 : this.mAllInsertionPointCreators) {
                NyO nyO = tE12.w2Z(rEs);
                if (!nyO.HaN(sA22)) continue;
                AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)this.createChild(qyU2, true);
                autoDragAndDropTests.mInsertionPointCreator = tE12;
                collection.add(autoDragAndDropTests);
            }
        });
    }

    private void listInsertModifierTests(qyU qyU2, Collection collection) {
        assert (bTe.BOK(this.mExpectedInsertActionsFile != null));
        this.exec(() -> {
            Object object;
            Iterator iterator2;
            REs rEs = (REs)this.mProjectWeOpenedToFindTestHierarchy.rLM();
            sA2 sA22 = this.mDataSourceCreator.w2Z(rEs);
            this.check(sA22).OhK();
            NyO nyO = this.mInsertionPointCreator.w2Z(rEs);
            this.check(nyO).OhK();
            this.check(nyO.HaN(sA22));
            int n2 = nyO.rLM(sA22) & 0xFFFFFFFF;
            dJS dJS2 = new dJS(4);
            for (Iterator iterator2 : rAg.w2Z(n2)) {
                dJS2.rLM(((rAg)((Object)iterator2)).HaN());
            }
            dJS dJS3 = new dJS(4);
            this.listModifierCombinations(dJS2, dJS3);
            iterator2 = dJS3.HaN();
            while (iterator2.hasNext()) {
                int n3 = (Integer)iterator2.next();
                object = (AutoDragAndDropTests)this.createChild(qyU2, false);
                ((AutoDragAndDropTests)object).init(n3);
                collection.add(object);
            }
            for (rAg rAg2 : rAg.w2Z) {
                if (rAg2.BOK(n2) || rAg2.BOK(0) || (object = this.mExpectedInsertActionsFile.w2Z(this.mDataSourceCreator, this.mInsertionPointCreator, rAg2.HaN())) == null) continue;
                if (((rKC)object).w2Z()) {
                    this.checkCorrectable("Did not list " + rAg2.BOK() + " as a possible insert modifier but the expected actions says that it should be possible", "RemoveInsertModifier", rAg2.BOK()).w2Z("");
                    continue;
                }
                this.mExpectedInsertActionsFile.BOK(this.mDataSourceCreator, this.mInsertionPointCreator, rAg2.HaN());
            }
        });
    }

    private void listModifierCombinations(dKL dKL2, dKL dKL3) {
        dKL3.rLM(0);
        this.listModifierCombinations(dKL2, dKL3, 0, 0);
    }

    private void listModifierCombinations(dKL dKL2, dKL dKL3, int n2, int n3) {
        for (int i2 = n3; i2 < dKL2.size(); ++i2) {
            int n4 = dKL2.cFc(i2);
            dKL3.rLM(n2 | n4);
            this.listModifierCombinations(dKL2, dKL3, n2, n3 + 1);
            this.listModifierCombinations(dKL2, dKL3, n2 | n4, n3 + 1);
        }
    }

    @Override
    protected void afterTestHierachyUpdated() {
        super.afterTestHierachyUpdated();
        this.mAllDataSourceCreators = null;
        this.mAllInsertionPointCreators = null;
        if (this.mDataSourceCreator == null && this.mProjectWeOpenedToFindTestHierarchy != null && this.getFile() != null && this.getFile().OhK()) {
            try {
                this.mProjectWeOpenedToFindTestHierarchy.Bh1();
            }
            catch (Exception exception) {
                LOG.BOK(exception);
            }
        }
        this.mProjectWeOpenedToFindTestHierarchy = null;
    }

    private void init(int n2) {
        this.mInsertModifiers = n2;
        this.mExpectedAction = this.mExpectedInsertActionsFile.w2Z(this.mDataSourceCreator, this.mInsertionPointCreator, n2);
    }

    @Override
    protected AQp getRootTestForSetup() {
        if (this.getFile() != null && this.mDataSourceCreator == null && this.mInsertionPointCreator == null && this.mInsertModifiers == -1) {
            return this;
        }
        return super.getRootTestForSetup();
    }

    @Override
    protected void setupDescendandTest(AQp aQp2) {
        super.setupDescendandTest(aQp2);
        AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)aQp2;
        if (this.mProject == null || ((REs)this.mProject.rLM()).M_()) {
            this.mProject = autoDragAndDropTests.openTestProject(autoDragAndDropTests.getFile());
        }
        DsV dsV2 = (DsV)((REs)this.mProject.rLM()).XTb();
        dsV2.w2Z(autoDragAndDropTests);
        autoDragAndDropTests.mProject = new TestProject((BitwigStudioTest)autoDragAndDropTests, (REs)this.mProject.rLM());
        autoDragAndDropTests.openedProject(autoDragAndDropTests.mProject);
    }

    @Override
    protected void tearDownDescendantTest(AQp aQp2, boolean bl2) {
        super.tearDownDescendantTest(aQp2, bl2);
        AutoDragAndDropTests autoDragAndDropTests = (AutoDragAndDropTests)aQp2;
        if (autoDragAndDropTests.mProject != null) {
            autoDragAndDropTests.mProject.zxv();
        }
        if (!bl2) {
            autoDragAndDropTests.mProject.Bh1();
            this.mProject = null;
        }
        autoDragAndDropTests.mProject = null;
    }

    @QTJ
    public void testDragAndDrop() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (this.mProject.stE()) {
            stringBuilder.append(this.mProject.agk());
            stringBuilder.append('\n');
            this.mProject.Jec();
            ++n2;
        }
        if (n2 > 1) {
            // empty if block
        }
        this.mProject.cFc();
        WaitingAsyncTaskCompletedListener waitingAsyncTaskCompletedListener = new WaitingAsyncTaskCompletedListener();
        this.asyncExec(() -> {
            REs rEs = (REs)this.mProject.rLM();
            sA2 sA22 = this.mDataSourceCreator.w2Z(rEs);
            this.check(sA22).OhK();
            NyO nyO = this.mInsertionPointCreator.w2Z(rEs);
            this.check(nyO).OhK();
            int n2 = nyO.rLM(sA22);
            WT wT2 = this.mInsertModifiers == 0 || (n2 | this.mInsertModifiers) == n2 ? nyO.w2Z(sA22, this.mInsertModifiers) : null;
            if (wT2 == null) {
                this.checkActionIsExpected(rKC.BOK);
                waitingAsyncTaskCompletedListener.taskCompleted();
                return;
            }
            if (!wT2.w2Z()) {
                this.checkActionIsExpected(rKC.w2Z);
                waitingAsyncTaskCompletedListener.taskCompleted();
                return;
            }
            this.asyncExec(() -> {
                wT2.UN3().w2Z(true);
                if (wT2.BOK()) {
                    try {
                        wT2.Bh1();
                    }
                    catch (Xod xod2) {
                        this.checkActionIsExpected(rKC.BOK);
                        waitingAsyncTaskCompletedListener.taskCompleted();
                        return;
                    }
                }
                this.asyncExec(() -> {
                    if (wT2.BOK()) {
                        wT2.rLM();
                    }
                    wT2.UN3().w2Z(false);
                });
                this.asyncExec(() -> wT2.BOK(this.inNewEvent(AsyncUtilities.w2Z(new AutoDragAndDropTests$2(this, rEs, wT2, nyO), waitingAsyncTaskCompletedListener))));
            });
        });
        try {
            this.waitForAsyncTask("Insert to finish", waitingAsyncTaskCompletedListener, 10L, TimeUnit.SECONDS);
        }
        catch (Xod | KDJ exception) {
            // empty catch block
        }
        VGW vGW = ((REs)this.mProject.rLM()).rW1();
        if (vGW != null) {
            this.waitForLatch("Bounce to finish", vGW.GvW(), 10L, TimeUnit.SECONDS);
        }
        this.mProject.wFl();
    }

    private void checkActionIsExpected(rKC rKC2) {
        if (this.mExpectedAction == null) {
            if (rKC2.w2Z()) {
                this.mExpectedInsertActionsFile.w2Z(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, rKC2);
            }
            this.mExpectedAction = rKC.rLM;
        }
        this.checkCorrectable("Actual insert action is correct", CORRECT_INSERT_ACTION_NAME, rKC2).w2Z(this.mExpectedAction);
    }

    @Override
    public void autoCorrect(String string, String string2) {
        if (string.equals(CORRECT_INSERT_ACTION_NAME)) {
            try {
                rKC rKC2;
                this.mExpectedAction = rKC2 = rKC.w2Z(string2);
                this.mExpectedInsertActionsFile.w2Z(this.mDataSourceCreator, this.mInsertionPointCreator, this.mInsertModifiers, rKC2);
            }
            catch (IMO iMO) {
                LOG.BOK(iMO);
            }
        } else if (string.equals("RemoveInsertModifier")) {
            rAg rAg2 = rAg.w2Z(string2);
            this.mExpectedInsertActionsFile.BOK(this.mDataSourceCreator, this.mInsertionPointCreator, rAg2.HaN());
        } else {
            super.autoCorrect(string, string2);
        }
    }

    private void listDataSourcesAndInsertionPointsForDocument(REs rEs) {
        aYR aYR2 = rEs.sYT();
        this.listDataSourcesAndInsertionPointsForTrackGroup(aYR2);
        Collections.sort(this.mAllDataSourceCreators);
        Collections.sort(this.mAllInsertionPointCreators);
    }

    private void listDataSourcesAndInsertionPointsForTrackGroup(aYR aYR4) {
        Ksw ksw2;
        ywn ywn3;
        int n2;
        int n3;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(aYR4);
        for (n3 = 0; n3 < aYR4.b2x(); ++n3) {
            n2 = n3;
            ywn3 = aYR4.eJL(n2);
            if (ywn3 instanceof Eja) {
                this.listDataSourcesAndInsertionPointsForTrack((Eja)ywn3);
            } else {
                this.listDataSourcesAndInsertionPointsForTrackGroup((aYR)ywn3);
            }
            this.addInsertionPoint(ywn3, "Before", ywn2 -> new TrackHeaderInsertionPoint(ywn2.qG(), sfv.w2Z, n2));
        }
        this.addInsertionPoint(aYR4, "EndOfMainTracksIn", aYR2 -> new TrackHeaderInsertionPoint((com.bitwig.flt.document.core.iface.lD)((Object)aYR2), sfv.w2Z, aYR2.b2x()));
        if (aYR4.b2x() > 1) {
            this.addDataSource(aYR4, "AllMainTracksIn", aYR2 -> new SoS(aYR2.Fyb()));
        }
        if (aYR4.Euc() > 1) {
            this.addDataSource(aYR4, "AllEffectTracksIn", aYR2 -> new SoS(aYR2.KjK()));
        }
        n3 = 0;
        while (n3 < aYR4.Euc()) {
            n2 = n3++;
            ywn3 = aYR4.Ayn(n2);
            this.listDataSourcesAndInsertionPointsForTrack((Eja)ywn3);
            this.addInsertionPoint(ywn3, "Before", eja -> new TrackHeaderInsertionPoint(eja.qG(), sfv.BOK, n2));
        }
        this.addInsertionPoint(aYR4, "EndOfEffectTracksIn", aYR3 -> new TrackHeaderInsertionPoint((com.bitwig.flt.document.core.iface.lD)((Object)aYR3), sfv.BOK, aYR4.Euc()));
        Ksw ksw3 = AutoDragAndDropTests.firstSceneWithClips(aYR4);
        if (ksw3 != null) {
            this.addDataSource(ksw3, ksw -> new Mpi(Collections.singleton(ksw), (LKF)ksw));
        }
        if ((ksw2 = AutoDragAndDropTests.firstEmptyScene(aYR4)) != null) {
            this.addDataSource(ksw2, ksw -> new Mpi(Collections.singleton(ksw), (LKF)ksw));
        }
    }

    private void listDataSourcesAndInsertionPointsForTrack(Eja eja) {
        Zea zea;
        this.listDataSourcesAndInsertionPointsForTrackOrTrackGroup(eja);
        lD lD2 = eja.LVD();
        this.listDataSourcesAndInsertionPointsForDeviceChain(lD2);
        Zea zea2 = AutoDragAndDropTests.firstSlotWithClip(eja);
        if (zea2 != null) {
            this.listDataSourcesAndInsertionPointsForSlot(zea2);
        }
        if ((zea = AutoDragAndDropTests.firstEmptySlot(eja)) != null) {
            this.listDataSourcesAndInsertionPointsForSlot(zea);
        }
    }

    private void listDataSourcesAndInsertionPointsForSlot(Zea zea2) {
        XB xB2 = zea2.Rss();
        if (xB2 != null) {
            this.addDataSource(zea2, zea -> new Mpi(Collections.singletonList(zea), (LKF)zea));
        }
        this.listDataSourcesAndInsertionPointsForSlotOrScene(zea2);
    }

    private void listDataSourcesAndInsertionPointsForSlotOrScene(LKF lKF2) {
        this.addInsertionPoint(lKF2, lKF -> new ClipLauncherClipInsertionPoint((ClJ)((Object)lKF), lKF.xou().Nfb().SWi()));
    }

    private static Zea firstSlotWithClip(Eja eja) {
        for (Zea zea : eja.iw1().zkl()) {
            if (zea.Rss() == null) continue;
            return zea;
        }
        return null;
    }

    private static Zea firstEmptySlot(Eja eja) {
        for (Zea zea : eja.iw1().zkl()) {
            if (zea.Rss() != null) continue;
            return zea;
        }
        return null;
    }

    private static Ksw firstSceneWithClips(aYR aYR2) {
        for (Ksw ksw : aYR2.Iso()) {
            ArrayList arrayList = new ArrayList();
            ksw.HaN(arrayList);
            if (arrayList.isEmpty()) continue;
            return ksw;
        }
        return null;
    }

    private static Ksw firstEmptyScene(aYR aYR2) {
        for (Ksw ksw : aYR2.Iso()) {
            ArrayList arrayList = new ArrayList();
            ksw.HaN(arrayList);
            if (!arrayList.isEmpty()) continue;
            return ksw;
        }
        return null;
    }

    private void listDataSourcesAndInsertionPointsForTrackOrTrackGroup(ywn ywn3) {
        this.addDataSource(ywn3, ywn2 -> new SoS(Collections.singletonList(ywn2)));
        if (ywn3.rW1().tUG() > 0) {
            this.addDataSource(ywn3.rW1().UN3(0), zsk2 -> new Ufl(Collections.singleton(zsk2), (zsk)zsk2, zsk2.aG2() + zsk2.eN1() / 2.0));
        }
        if (ywn3.qG() != null) {
            this.addInsertionPoint(ywn3, "Onto", ywn2 -> TrackHeaderInsertionPoint.w2Z(ywn2, true, ywn2.FLk().Nfb().KEp()));
        }
        this.addInsertionPoint(ywn3, "Time0In", ywn2 -> new ArrangerClipInsertionPoint((dfU)((Object)ywn2), 0.0, ywn2.FLk().Nfb().MfG(), null, false));
    }

    private void listDataSourcesAndInsertionPointsForDeviceChain(lD lD3) {
        this.addInsertionPoint(lD3, "StartOf", lD2 -> new DeviceChainInsertionPoint((urf)((Object)lD2), 0, ((Eja)lD2.bsM(Eja.class)).v2z().Rss()));
        for (int i2 = 0; i2 < lD3.RTr(); ++i2) {
            int n2 = i2;
            DFk dFk3 = lD3.zxv(i2);
            this.listDataSourcesAndInsertionPointsForDevice(dFk3);
            if (i2 <= 0) continue;
            this.addInsertionPoint(dFk3, "Before", dFk2 -> new DeviceChainInsertionPoint(dFk2.JRm(), n2, dFk2.Pwg().v2z().Rss()));
        }
        if (lD3.RTr() > 1) {
            this.addInsertionPoint(lD3, "EndOf", lD2 -> new DeviceChainInsertionPoint((urf)((Object)lD2), lD2.RTr(), ((Eja)lD2.bsM(Eja.class)).v2z().Rss()));
            this.addDataSource(lD3, "AllDevicesIn", lD2 -> new com.bitwig.flt.document.core.iface.clipboard.device.cw(lD2.eJL()));
        }
    }

    private void listDataSourcesAndInsertionPointsForDevice(DFk dFk3) {
        this.addDataSource(dFk3, dFk2 -> new com.bitwig.flt.document.core.iface.clipboard.device.cw(Collections.singletonList(dFk2)));
        dFk3.uRl().forEach(this::listDataSourcesAndInsertionPointsForComponent);
        this.addInsertionPoint(dFk3, "Onto", dFk2 -> {
            lD lD2 = dFk2.JRm();
            int n2 = lD2.w2Z((hne)((Object)dFk2));
            Eja eja = dFk2.Pwg();
            return new DeviceChainInsertionPoint(lD2, n2, true, true, eja.v2z().Rss());
        });
    }

    private void listDataSourcesAndInsertionPointsForComponent(Xbn xbn) {
        if (xbn instanceof XMP) {
            this.listDataSourcesAndInsertionPointsForDrumPads((XMP)xbn);
        } else if (xbn instanceof YlS) {
            this.listDataSourcesAndInsertionPointsForMultiNestedDeviceChainContainer((YlS)xbn);
        } else if (xbn instanceof kWU) {
            this.listDataSourcesAndInsertionPointsForNestedDeviceChainSlot((kWU)xbn);
        }
    }

    private void listDataSourcesAndInsertionPointsForMultiNestedDeviceChainContainer(YlS ylS) {
        for (MXO mXO : ylS.Jec()) {
            this.listDataSourcesAndInsertionPointsForNestedDeviceChain(mXO);
        }
    }

    private void listDataSourcesAndInsertionPointsForDrumPads(XMP xMP) {
        this.listDataSourcesAndInsertionPointsForMultiNestedDeviceChainContainer(xMP);
        List list = xMP.Jec();
        for (MXO mXO : list) {
            this.addDataSource(mXO, mXO2 -> new uDW(list, mXO));
        }
        for (int i2 = 0; i2 < 128; ++i2) {
            this.addInsertionPoint(xMP.OhK(i2), "Onto", fz12 -> new DrumPadInsertionPoint((zWL)((Object)fz12), xMP.dMX().IL()));
        }
    }

    private void listDataSourcesAndInsertionPointsForNestedDeviceChainSlot(kWU kWU2) {
        this.listDataSourcesAndInsertionPointsForNestedDeviceChain(kWU2.CKO());
    }

    private void listDataSourcesAndInsertionPointsForNestedDeviceChain(MXO mXO) {
        this.listDataSourcesAndInsertionPointsForDeviceChain(mXO.LVD());
    }

    private void addDataSource(TO tO2, cw cw3) {
        this.addDataSource(tO2, "", cw3);
    }

    private void addDataSource(TO tO2, String string, cw cw3) {
        com.bitwig.ramona.path.aOa aOa2 = tO2.ZlC();
        String string2 = string + AutoDragAndDropTests.getObjectName(tO2);
        Class<?> clazz = tO2.getClass();
        this.mAllDataSourceCreators.add(new kln(this, string2, aOa2, clazz, cw3));
    }

    private void addInsertionPoint(TO tO2, RZp rZp) {
        this.addInsertionPoint(tO2, "", rZp);
    }

    private void addInsertionPoint(TO tO2, String string, RZp rZp) {
        com.bitwig.ramona.path.aOa aOa2 = tO2.ZlC();
        String string2 = string + AutoDragAndDropTests.getObjectName(tO2);
        Class<?> clazz = tO2.getClass();
        this.mAllInsertionPointCreators.add(new nCp(this, string2, aOa2, clazz, rZp));
    }

    private static String getObjectName(TO tO2) {
        com.bitwig.ramona.path.aOa aOa2 = tO2.ZlC();
        String string = aOa2.toString();
        String string2 = "track_group/";
        if (string.startsWith("track_group/")) {
            string = string.substring("track_group/".length());
        }
        return fbb.w2Z(tO2.cFc().Whc(), true) + "[" + string.replace('/', ':') + "]";
    }
}

